/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.painting.tools.brush;

public class Bezier {
    private final double ax;
    private final double bx;
    private final double cx;
    private final double ay;
    private final double by;
    private final double cy;
    private final double startGradient;
    private final double endGradient;

    public Bezier(double p1x, double p1y, double p2x, double p2y) {
        this.cx = 3.0 * p1x;
        this.bx = 3.0 * (p2x - p1x) - this.cx;
        this.ax = 1.0 - this.cx - this.bx;
        this.cy = 3.0 * p1y;
        this.by = 3.0 * (p2y - p1y) - this.cy;
        this.ay = 1.0 - this.cy - this.by;
        this.startGradient = p1x > 0.0 ? p1y / p1x : (p1y == 0.0 && p2x > 0.0 ? p2y / p2x : 0.0);
        this.endGradient = p2x < 1.0 ? (p2y - 1.0) / (p2x - 1.0) : (p2x == 1.0 && p1x < 1.0 ? (p1y - 1.0) / (p1x - 1.0) : 0.0);
    }

    public double sampleCurveX(double t) {
        return ((this.ax * t + this.bx) * t + this.cx) * t;
    }

    public double sampleCurveY(double t) {
        return ((this.ay * t + this.by) * t + this.cy) * t;
    }

    public double sampleCurveDerivativeX(double t) {
        return (3.0 * this.ax * t + 2.0 * this.bx) * t + this.cx;
    }

    public double solveCurveX(double x, double epsilon) {
        double x2;
        double t2 = x;
        for (int i = 0; i < 8; ++i) {
            x2 = this.sampleCurveX(t2) - x;
            if (Math.abs(x2) < epsilon) {
                return t2;
            }
            double d2 = this.sampleCurveDerivativeX(t2);
            if (Math.abs(d2) < 1.0E-6) break;
            t2 -= x2 / d2;
        }
        double t0 = 0.0;
        double t1 = 1.0;
        t2 = x;
        while (t0 < t1) {
            x2 = this.sampleCurveX(t2);
            if (Math.abs(x2 - x) < epsilon) {
                return t2;
            }
            if (x > x2) {
                t0 = t2;
            } else {
                t1 = t2;
            }
            t2 = (t1 - t0) * 0.5 + t0;
        }
        return t2;
    }

    public double solve(double x, double epsilon) {
        if (x < 0.0) {
            return 0.0 + this.startGradient * x;
        }
        if (x > 1.0) {
            return 1.0 + this.endGradient * (x - 1.0);
        }
        return this.sampleCurveY(this.solveCurveX(x, epsilon));
    }
}

