/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.network.ClientHandler;
import me.dantaeusb.zetter.network.packet.SCanvasSyncPacket;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.CanvasDataType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SEaselCanvasInitializationPacket
extends SCanvasSyncPacket<CanvasData> {
    public final int easelEntityId;

    public SEaselCanvasInitializationPacket(int easelEntityId, String canvasCode, CanvasData canvasData, long timestamp) {
        super(canvasCode, canvasData, timestamp);
        this.easelEntityId = easelEntityId;
    }

    public static SEaselCanvasInitializationPacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            int easelEntityId = networkBuffer.readInt();
            String canvasCode = networkBuffer.m_130136_(64);
            long timestamp = networkBuffer.readLong();
            CanvasData canvasData = (CanvasData)((Object)((CanvasDataType)ZetterCanvasTypes.CANVAS.get()).readPacketData(networkBuffer));
            return new SEaselCanvasInitializationPacket(easelEntityId, canvasCode, canvasData, timestamp);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading SEaselCanvasInitializationPacket: " + e);
            return null;
        }
    }

    @Override
    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.writeInt(this.easelEntityId);
        networkBuffer.m_130072_(this.canvasCode, 64);
        networkBuffer.writeLong(this.timestamp);
        ((CanvasDataType)ZetterCanvasTypes.CANVAS.get()).writePacketData((CanvasData)this.canvasData, networkBuffer);
    }

    public static void handle(SEaselCanvasInitializationPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            Zetter.LOG.warn("SEaselReset context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processEaselCanvasInitialization(packetIn, (Level)clientWorld.get()));
    }

    @Override
    public String toString() {
        return "SEaselCanvasInitializationPacket[easel=" + this.easelEntityId + ",canvasCode=" + this.canvasCode + ",timestamp=" + this.timestamp + "]";
    }
}

