/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.core.ZetterRegistries;
import me.dantaeusb.zetter.network.ClientHandler;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasDataType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SCanvasSyncPacket<T extends AbstractCanvasData> {
    public final String canvasCode;
    public final long timestamp;
    public final T canvasData;

    public SCanvasSyncPacket(String canvasCode, T canvasData, long timestamp) {
        this.canvasCode = canvasCode;
        this.timestamp = timestamp;
        this.canvasData = canvasData;
    }

    public static SCanvasSyncPacket<?> readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            String type = networkBuffer.m_130136_(128);
            String canvasCode = networkBuffer.m_130136_(128);
            long timestamp = networkBuffer.readLong();
            CanvasDataType canvasDataType = (CanvasDataType)ZetterRegistries.CANVAS_TYPE.get().getValue(new ResourceLocation(type));
            if (canvasDataType == null) {
                throw new IllegalArgumentException("Unable to find canvas type " + type);
            }
            Object canvasData = canvasDataType.readPacketData(networkBuffer);
            return new SCanvasSyncPacket(canvasCode, canvasData, timestamp);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading SCanvasSyncMessage: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.m_130072_(((AbstractCanvasData)((Object)this.canvasData)).getType().resourceLocation.toString(), 128);
        networkBuffer.m_130072_(this.canvasCode, 128);
        networkBuffer.writeLong(this.timestamp);
        CanvasDataType canvasDataType = (CanvasDataType)ZetterRegistries.CANVAS_TYPE.get().getValue(((AbstractCanvasData)((Object)this.canvasData)).getType().resourceLocation);
        assert (canvasDataType != null);
        canvasDataType.writePacketData(this.canvasData, networkBuffer);
    }

    public static void handle(SCanvasSyncPacket<?> packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (clientWorld.isEmpty()) {
            Zetter.LOG.error("SCanvasSyncMessage context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processCanvasSync(packetIn, (Level)clientWorld.get()));
    }

    public String toString() {
        return "SCanvasSyncMessage[canvas=" + this.canvasCode + ",timestamp=" + this.timestamp + "]";
    }
}

