/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.entity.item.state.representation;

import java.nio.ByteBuffer;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.painting.Tools;
import me.dantaeusb.zetter.painting.parameters.AbstractToolParameters;
import net.minecraft.network.FriendlyByteBuf;

public class CanvasAction {
    private static final Random RANDOM = new Random();
    public static final int MAX_ACTIONS_IN_BUFFER = 100;
    public static final long MAX_TIME = 5000L;
    private static final long MAX_INACTIVE_TIME = 750L;
    public final int id;
    private UUID authorUUID;
    public final Tools tool;
    public final int color;
    public final AbstractToolParameters parameters;
    private final Long startTime;
    private Long commitTime;
    private static final int FRAME_SIZE = 11;
    public static final int BUFFER_SIZE = 1100;
    private ByteBuffer subActionBuffer;
    private CanvasSubAction lastAction;
    private boolean sent = false;
    private boolean sync = false;
    private boolean canceled = false;

    public CanvasAction(UUID authorId, Tools tool, int color, AbstractToolParameters parameters) {
        this(authorId, tool, color, parameters, System.currentTimeMillis(), ByteBuffer.allocateDirect(1100));
    }

    private CanvasAction(UUID authorId, Tools tool, int color, AbstractToolParameters parameters, Long startTime, ByteBuffer actionBuffer) {
        this.id = RANDOM.nextInt();
        this.authorUUID = authorId;
        this.tool = tool;
        this.color = color;
        this.parameters = parameters;
        this.startTime = startTime;
        this.subActionBuffer = actionBuffer;
    }

    private CanvasAction(int actionId, Tools tool, int color, AbstractToolParameters parameters, Long startTime, Long commitTime, ByteBuffer actionBuffer, boolean canceled) {
        this.id = actionId;
        this.tool = tool;
        this.color = color;
        this.parameters = parameters;
        this.startTime = startTime;
        this.subActionBuffer = actionBuffer.asReadOnlyBuffer();
        this.commitTime = commitTime;
        this.sent = true;
        this.canceled = canceled;
    }

    public void setAuthorUUID(UUID authorUUID) {
        if (this.authorUUID != null) {
            throw new IllegalStateException("This action already has Author UUID set");
        }
        this.authorUUID = authorUUID;
    }

    @Nullable
    public UUID getAuthorUUID() {
        return this.authorUUID;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getCommitTime() {
        return this.commitTime;
    }

    public boolean canContinue(UUID authorId, Tools tool, int color, AbstractToolParameters parameters) {
        return this.commitTime == null && !this.shouldCommit() && this.isActionCompatible(authorId, tool, color, parameters);
    }

    public boolean isActionCompatible(UUID authorId, Tools tool, int color, AbstractToolParameters parameters) {
        return this.authorUUID == authorId && this.tool == tool && this.color == color;
    }

    public boolean shouldCommit() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.startTime > 5000L) {
            return true;
        }
        if (this.lastAction != null && currentTime - (this.startTime + (long)this.lastAction.time) > 750L) {
            return true;
        }
        return !this.subActionBuffer.hasRemaining();
    }

    public void addFrame(float posX, float posY) {
        if (this.commitTime != null) {
            throw new IllegalStateException("Cannot add frame to committed action buffer");
        }
        if (this.shouldCommit()) {
            throw new IllegalStateException("Cannot add frame to action buffer that should be committed");
        }
        long currentTime = System.currentTimeMillis();
        int passedTime = (int)(currentTime - this.startTime);
        CanvasSubAction action = new CanvasSubAction(passedTime, posX, posY);
        CanvasSubAction.writeToBuffer(action, this.subActionBuffer);
        this.lastAction = action;
    }

    public Stream<CanvasSubAction> getSubActionStream() {
        ByteBuffer subActionBuffer = this.isCommitted() ? this.subActionBuffer : this.subActionBuffer.duplicate().flip();
        subActionBuffer.rewind();
        if (subActionBuffer.limit() % 11 != 0) {
            throw new IllegalStateException("Incorrect amount of frames in buffer");
        }
        if (subActionBuffer.limit() == 0) {
            throw new IllegalStateException("Applied action buffer is empty");
        }
        return Stream.generate(() -> CanvasSubAction.readFromBuffer(subActionBuffer)).limit(subActionBuffer.limit() / 11);
    }

    public int countActions() {
        if (this.subActionBuffer.isReadOnly()) {
            return this.subActionBuffer.limit() / 11;
        }
        return this.subActionBuffer.position() / 11;
    }

    public void commit() {
        if (this.commitTime != null) {
            Zetter.LOG.warn("Already committed");
            return;
        }
        if (this.subActionBuffer.limit() == 0) {
            Zetter.LOG.warn("Committing empty action buffer!");
        }
        this.sealBuffer();
        this.commitTime = System.currentTimeMillis();
    }

    public boolean isCommitted() {
        return this.commitTime != null;
    }

    public void setSent() {
        if (this.commitTime == null) {
            this.commit();
        }
        this.sent = true;
    }

    public boolean isSent() {
        return this.sent;
    }

    public void setSync() {
        this.sync = true;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setCanceled(boolean canceled) {
        if (this.commitTime == null) {
            this.commit();
        }
        this.canceled = canceled;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Nullable
    public CanvasSubAction getLastAction() {
        return this.lastAction;
    }

    public void sealBuffer() {
        this.subActionBuffer.flip();
        this.subActionBuffer = this.subActionBuffer.asReadOnlyBuffer();
    }

    public static void writePacketData(CanvasAction actionBuffer, FriendlyByteBuf buffer) {
        buffer.writeInt(actionBuffer.id);
        buffer.m_130072_(actionBuffer.tool.toString(), 32);
        buffer.writeInt(actionBuffer.color);
        buffer.writeLong(actionBuffer.startTime.longValue());
        buffer.writeLong(actionBuffer.commitTime.longValue());
        buffer.writeBoolean(actionBuffer.canceled);
        AbstractToolParameters.writePacketData(actionBuffer.parameters, buffer);
        buffer.writeInt(actionBuffer.subActionBuffer.rewind().limit());
        buffer.writeBytes(actionBuffer.subActionBuffer);
    }

    public static CanvasAction readPacketData(FriendlyByteBuf buffer) {
        int actionId = buffer.readInt();
        Tools tool = Tools.valueOf(buffer.m_130136_(32));
        int color = buffer.readInt();
        Long startTime = buffer.readLong();
        Long commitTime = buffer.readLong();
        boolean canceled = buffer.readBoolean();
        AbstractToolParameters parameters = AbstractToolParameters.readPacketData(buffer, tool);
        int bufferSize = buffer.readInt();
        try {
            ByteBuffer actionsBuffer = buffer.readBytes(bufferSize).nioBuffer();
            return new CanvasAction(actionId, tool, color, parameters, startTime, commitTime, actionsBuffer, canceled);
        }
        catch (IndexOutOfBoundsException e) {
            Zetter.LOG.error((Object)e);
            return null;
        }
    }

    public static class CanvasSubAction {
        public final byte meta;
        public final int time;
        public final float posX;
        public final float posY;

        public CanvasSubAction(int time, float posX, float posY) {
            this.meta = 1;
            if (time > 65535) {
                throw new IllegalStateException("Time offset for action is to big");
            }
            this.time = time;
            this.posX = posX;
            this.posY = posY;
        }

        private CanvasSubAction(byte meta, int time, float posX, float posY) {
            this.meta = meta;
            this.time = time;
            this.posX = posX;
            this.posY = posY;
        }

        public static void writeToBuffer(CanvasSubAction action, ByteBuffer buffer) {
            buffer.put((byte)1);
            buffer.put((byte)(action.time & 0xFF));
            buffer.put((byte)(action.time >> 8 & 0xFF));
            buffer.putFloat(action.posX);
            buffer.putFloat(action.posY);
        }

        public static CanvasSubAction readFromBuffer(ByteBuffer buffer) {
            byte meta = buffer.get();
            int time = buffer.get() << 8 & buffer.get();
            float posX = buffer.getFloat();
            float posY = buffer.getFloat();
            return new CanvasSubAction(meta, time, posX, posY);
        }
    }
}

