/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractEaselWidget;
import me.dantaeusb.zetter.menu.EaselMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class PaletteWidget
extends AbstractEaselWidget
implements Renderable {
    static final int PALETTE_SCALE_FACTOR = 10;
    static final int PALETTE_OFFSET = 11;
    static final int PALETTE_COLS = 2;
    static final int WIDTH = 21;
    static final int HEIGHT = 10 + EaselMenu.PALETTE_SLOTS / 2 * 11;
    public static final int SWAP_HOTKEY = 88;

    public PaletteWidget(EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 21, HEIGHT, (Component)Component.m_237115_((String)"container.zetter.painting.palette"));
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        int slotIndex = -1;
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        for (int i = 0; i < EaselMenu.PALETTE_SLOTS; ++i) {
            int slotY;
            int slotX = this.m_252754_() + i % 2 * 11;
            if (!EaselScreen.isInRect(slotX, slotY = this.m_252907_() + i / 2 * 11, 10, 10, iMouseX, iMouseY) || !this.m_7972_(button)) continue;
            slotIndex = i;
            break;
        }
        if (slotIndex == -1) {
            return false;
        }
        ((EaselMenu)this.parentScreen.m_6262_()).setCurrentPaletteSlot(slotIndex);
        return true;
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.drawPalette(guiGraphics);
        this.drawPaletteSelector(guiGraphics, ((EaselMenu)this.parentScreen.m_6262_()).getCurrentPaletteSlot());
    }

    protected void drawPalette(GuiGraphics guiGraphics) {
        if (!((EaselMenu)this.parentScreen.m_6262_()).isPaletteAvailable()) {
            return;
        }
        for (int i = 0; i < EaselMenu.PALETTE_SLOTS; ++i) {
            int fromX = this.m_252754_() + i % 2 * 11;
            int fromY = this.m_252907_() + i / 2 * 11;
            int color = ((EaselMenu)this.parentScreen.m_6262_()).getPaletteColor(i);
            guiGraphics.m_280509_(fromX, fromY, fromX + 10, fromY + 10, color);
        }
    }

    protected void drawPaletteSelector(GuiGraphics guiGraphics, int currentPaletteSlot) {
        if (!((EaselMenu)this.parentScreen.m_6262_()).isPaletteAvailable()) {
            return;
        }
        int SELECTOR_POSITION_U = 82;
        boolean SELECTOR_POSITION_V = false;
        int PALETTE_BORDER = 3;
        int selectorPositionX = this.m_252754_() + (currentPaletteSlot % 2 != 0 ? 11 : 0) - 3;
        int selectorPositionY = this.m_252907_() + currentPaletteSlot / 2 * 11 - 3;
        guiGraphics.m_280218_(AbstractEaselWidget.EASEL_WIDGETS_TEXTURE_RESOURCE, selectorPositionX, selectorPositionY, 82, 0, 16, 16);
    }
}

