/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.registry.datapack;

import com.rosemods.windswept.core.Windswept;
import com.rosemods.windswept.core.registry.datapack.WindsweptPlacedFeatures;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public final class WindsweptBiomes {
    public static final ResourceKey<Biome> CHESTNUT_FOREST = WindsweptBiomes.createKey("chestnut_forest");
    public static final ResourceKey<Biome> SNOWY_CHESTNUT_FOREST = WindsweptBiomes.createKey("snowy_chestnut_forest");
    public static final ResourceKey<Biome> PINE_BARRENS = WindsweptBiomes.createKey("pine_barrens");
    public static final ResourceKey<Biome> SNOWY_PINE_BARRENS = WindsweptBiomes.createKey("snowy_pine_barrens");
    public static final ResourceKey<Biome> LAVENDER_HILLS = WindsweptBiomes.createKey("lavender_hills");
    public static final ResourceKey<Biome> LAVENDER_FIELDS = WindsweptBiomes.createKey("lavender_fields");
    public static final ResourceKey<Biome> TUNDRA = WindsweptBiomes.createKey("tundra");
    public static final ResourceKey<Biome> FLOWERING_SAVANNA = WindsweptBiomes.createKey("flowering_savanna");

    public static void bootstrap(BootstapContext<Biome> context) {
        HolderGetter features = context.m_255420_(Registries.f_256988_);
        HolderGetter carvers = context.m_255420_(Registries.f_257003_);
        context.m_255272_(CHESTNUT_FOREST, (Object)WindsweptBiomes.chestnutForest(false, (HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(SNOWY_CHESTNUT_FOREST, (Object)WindsweptBiomes.chestnutForest(true, (HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(PINE_BARRENS, (Object)WindsweptBiomes.pineBarrens(false, (HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(SNOWY_PINE_BARRENS, (Object)WindsweptBiomes.pineBarrens(true, (HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(LAVENDER_HILLS, (Object)WindsweptBiomes.lavender(true, (HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(LAVENDER_FIELDS, (Object)WindsweptBiomes.lavender(false, (HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(TUNDRA, (Object)WindsweptBiomes.tundra((HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(FLOWERING_SAVANNA, (Object)WindsweptBiomes.savanna((HolderGetter<PlacedFeature>)features, carvers));
    }

    public static ResourceKey<Biome> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Windswept.location(name));
    }

    private static Biome chestnutForest(boolean snowy, HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195451_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.TALL_FERNS);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.FERNS);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.CHESTNUT_TREES);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.TALL_BIRCH_TREES);
        return WindsweptBiomes.biome(snowy ? -0.3f : 0.3f, 0.4f, 4159204, 329011, 12638463, true, generation, WindsweptBiomes.baseChestnutSpawns()).m_47592_();
    }

    private static MobSpawnSettings.Builder baseChestnutSpawns() {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 12, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 10, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 8, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 12, 4, 4));
        return spawns;
    }

    private static Biome pineBarrens(boolean snowy, HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.PINE_FALLEN_LOG);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195451_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.TALL_FERNS);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.FERNS);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.LUPINE);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.GINGER_PATCH);
        if (!snowy) {
            generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.DRY_MOSS_PATCH_SMALL);
        }
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.DRY_MOSS_ROCK);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.HOLLY_BUSH);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.PINE_TREES);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.MEGA_SPRUCE_TREES);
        return WindsweptBiomes.biome(snowy ? -0.2f : 0.8f, 0.4f, 4159204, 329011, 12638463, true, generation, WindsweptBiomes.basePineSpawns()).m_47592_();
    }

    private static MobSpawnSettings.Builder basePineSpawns() {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 15, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 10, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 8, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 12, 4, 4));
        return spawns;
    }

    private static Biome tundra(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.TUNDRA_FALLEN_LOG);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195451_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.SNOWY_GELISOL);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.LUPINE);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.DRY_MOSS_PATCH_LARGE);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.GELISOL_PATCH);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.DRY_MOSS_ROCK);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.HOLLY_BUSH);
        return WindsweptBiomes.biome(1.0f, 0.2f, 4159204, 329011, 12638463, false, generation, WindsweptBiomes.baseTundraSpawns()).m_47592_();
    }

    private static MobSpawnSettings.Builder baseTundraSpawns() {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 8, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 2, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20466_, 12, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147035_, 10, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 12, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20514_, 8, 1, 2));
        return spawns;
    }

    private static Biome lavender(boolean hills, HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195451_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generation);
        if (hills) {
            generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.LAVENDER_TALL_BIRCH_TREES);
            generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.LAVENDER_CHESTNUT_TREES);
        } else {
            generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.LAVENDER_FIELDS_TREES);
        }
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.LARGE_WHITE_ROSE);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.LAVENDER);
        return WindsweptBiomes.biome(0.4f, 0.7f, 4159204, 329011, 12638463, true, generation, WindsweptBiomes.baseLavenderSpawns()).m_47592_();
    }

    private static MobSpawnSettings.Builder baseLavenderSpawns() {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 15, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 8, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20560_, 8, 1, 2));
        return spawns;
    }

    private static Biome savanna(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126700_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.YELLOW_PETALS);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.FLOWERING_SAVANNA_TREES);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.COMMON_LIONS_TAIL);
        return WindsweptBiomes.biome(1.2f, 0.0f, 4159204, 329011, 12638463, true, generation, WindsweptBiomes.baseSavannaSpawns()).m_47592_();
    }

    private static MobSpawnSettings.Builder baseSavannaSpawns() {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20457_, 1, 2, 6));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20560_, 1, 1, 1));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20466_, 8, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 12, 4, 4));
        return spawns;
    }

    private static Biome.BiomeBuilder biome(float temp, float downfall, int waterColor, int waterFogColor, int fogColor, boolean precipitation, BiomeGenerationSettings.Builder generation, MobSpawnSettings.Builder spawns) {
        return new Biome.BiomeBuilder().m_264558_(precipitation).m_47609_(temp).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48040_(WindsweptBiomes.calculateSkyColor(temp)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(OverworldBiomes.f_194839_).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_255380_());
    }

    private static int calculateSkyColor(float temperature) {
        float clampedTemp = Mth.m_14036_((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62f - clampedTemp * 0.05f), (float)(0.5f + clampedTemp * 0.1f), (float)1.0f);
    }
}

