/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.other;

import com.rosemods.windswept.common.block.IWoodenBucketPickupBlock;
import com.rosemods.windswept.common.dispense.FrostArrowDispenseBehavior;
import com.rosemods.windswept.common.item.WoodenBucketItem;
import com.rosemods.windswept.core.other.WindsweptConstants;
import com.rosemods.windswept.core.registry.WindsweptItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public final class WindsweptDispenseBehaviors {
    public static void registerDispenseBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)WindsweptItems.WOODEN_BUCKET.get()), WindsweptDispenseBehaviors::fillBucket);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)WindsweptItems.WOODEN_WATER_BUCKET.get()), WindsweptDispenseBehaviors::emptyWaterBucket);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)WindsweptItems.WOODEN_POWDER_SNOW_BUCKET.get()), WindsweptDispenseBehaviors::emptyPowderSnowBucket);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)WindsweptItems.FROST_ARROW.get()), (DispenseItemBehavior)new FrostArrowDispenseBehavior());
        if (ModList.get().isLoaded("create")) {
            DispenserBlock.m_52672_((ItemLike)((ItemLike)WindsweptItems.WOODEN_HONEY_BUCKET.get()), WindsweptDispenseBehaviors::emptyHoneyBucket);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)WindsweptItems.WOODEN_CHOCOLATE_BUCKET.get()), WindsweptDispenseBehaviors::emptyChocolateBucket);
        }
    }

    private static ItemStack fillBucket(BlockSource source, ItemStack stack) {
        IWoodenBucketPickupBlock pickupBlock;
        BlockPos pos;
        Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        ServerLevel level = source.m_7727_().m_6018_();
        BlockState state = level.m_8055_(pos = source.m_7961_().m_121945_(direction));
        Block block = state.m_60734_();
        if (block instanceof IWoodenBucketPickupBlock && (pickupBlock = (IWoodenBucketPickupBlock)block).canPickupFromWoodenBucket((LevelAccessor)level, pos, state)) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            ItemStack filled = pickupBlock.getWoodenBucketItem(state).m_7968_();
            filled.m_41721_(stack.m_41773_());
            return filled;
        }
        return stack;
    }

    private static ItemStack emptyBucket(Block fill, BlockSource source, ItemStack stack) {
        BlockPos pos;
        Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        ServerLevel level = source.m_7727_().m_6018_();
        if (level.m_8055_(pos = source.m_7961_().m_121945_(direction)).m_60795_()) {
            level.m_46597_(pos, fill.m_49966_());
            return WoodenBucketItem.getEmpty(stack, null, null);
        }
        return stack;
    }

    private static ItemStack emptyWaterBucket(BlockSource source, ItemStack stack) {
        return WindsweptDispenseBehaviors.emptyBucket(Blocks.f_49990_, source, stack);
    }

    private static ItemStack emptyPowderSnowBucket(BlockSource source, ItemStack stack) {
        return WindsweptDispenseBehaviors.emptyBucket(Blocks.f_152499_, source, stack);
    }

    private static ItemStack emptyHoneyBucket(BlockSource source, ItemStack stack) {
        return WindsweptDispenseBehaviors.emptyBucket((Block)ForgeRegistries.BLOCKS.getValue(WindsweptConstants.HONEY), source, stack);
    }

    private static ItemStack emptyChocolateBucket(BlockSource source, ItemStack stack) {
        return WindsweptDispenseBehaviors.emptyBucket((Block)ForgeRegistries.BLOCKS.getValue(WindsweptConstants.CHOCOLATE), source, stack);
    }
}

