/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.mixin;

import com.rosemods.windswept.common.enchantment.curse.SlippingCurseEnchantment;
import com.rosemods.windswept.common.item.AntlerHelmetItem;
import com.rosemods.windswept.common.item.SnowBootsItem;
import com.rosemods.windswept.core.other.tags.WindsweptEntityTypeTags;
import com.rosemods.windswept.core.registry.WindsweptEffects;
import com.rosemods.windswept.core.registry.WindsweptItems;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    private LivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void m_146917_(int ticks) {
        if (((LivingEntity)this).m_21023_((MobEffect)WindsweptEffects.FROST_RESISTANCE.get()) || this.m_6095_().m_204039_(EntityTypeTags.f_144294_)) {
            ticks = 0;
        }
        super.m_146917_(ticks);
    }

    public int m_146888_() {
        if (((LivingEntity)this).m_21023_((MobEffect)WindsweptEffects.FROST_RESISTANCE.get()) || this.m_6095_().m_204039_(EntityTypeTags.f_144294_)) {
            return 0;
        }
        return super.m_146888_();
    }

    public boolean m_146890_() {
        if (this.f_146808_ && this.m_6095_().m_204039_(WindsweptEntityTypeTags.CONVERT_TO_CHILLED)) {
            return false;
        }
        return super.m_146890_();
    }

    @Inject(method={"canFreeze"}, at={@At(value="HEAD")}, cancellable=true)
    private void canFreeze(CallbackInfoReturnable<Boolean> info) {
        LivingEntity entity = (LivingEntity)this;
        info.setReturnValue((Object)(!entity.m_6095_().m_204039_(EntityTypeTags.f_144294_) && !entity.m_5833_() && !entity.m_21023_((MobEffect)WindsweptEffects.FROST_RESISTANCE.get()) ? 1 : 0));
    }

    @Inject(method={"onChangedBlock"}, at={@At(value="TAIL")})
    private void onChangedBlock(BlockPos pos, CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        if (SnowBootsItem.canApplySnowSpeed(entity)) {
            SnowBootsItem.tryAddSnowSpeed(entity);
        } else if (!entity.m_9236_().m_8055_(entity.m_20097_()).m_60795_() || entity.m_21255_() || !entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)WindsweptItems.SNOW_BOOTS.get())) {
            SnowBootsItem.removeSnowSpeed(entity);
        }
        if (!entity.m_20142_() || !entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)WindsweptItems.ANTLER_HELMET.get())) {
            AntlerHelmetItem.removeSprintDamage(entity);
        }
        AntlerHelmetItem.tryAddSprintDamage(entity);
        SlippingCurseEnchantment.attemptDamageBoots(entity);
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    private void checkFallDamage(double d, boolean p_20991_, BlockState state, BlockPos pos, CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        if (!entity.m_9236_().f_46443_ && p_20991_ && entity.f_19789_ > 0.0f) {
            SnowBootsItem.removeSnowSpeed(entity);
            if (SnowBootsItem.canApplySnowSpeed(entity)) {
                SnowBootsItem.tryAddSnowSpeed(entity);
            }
            SlippingCurseEnchantment.attemptDamageBoots(entity);
        }
    }
}

