/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core;

import com.rosemods.windswept.core.WindsweptConfig;
import com.rosemods.windswept.core.data.client.WindsweptLangProvider;
import com.rosemods.windswept.core.data.client.WindsweptModelProvider;
import com.rosemods.windswept.core.data.client.WindsweptParticleProvider;
import com.rosemods.windswept.core.data.client.WindsweptSoundProvider;
import com.rosemods.windswept.core.data.client.WindsweptSplashProvider;
import com.rosemods.windswept.core.data.client.WindsweptSpriteSourceProvider;
import com.rosemods.windswept.core.data.server.WindsweptDatapackProvider;
import com.rosemods.windswept.core.data.server.WindsweptLootTableProvider;
import com.rosemods.windswept.core.data.server.WindsweptRecipeProvider;
import com.rosemods.windswept.core.data.server.modifiers.WindsweptAdvancementModifierProvider;
import com.rosemods.windswept.core.data.server.modifiers.WindsweptChunkGeneratorModifierProvider;
import com.rosemods.windswept.core.data.server.modifiers.WindsweptLootModifierProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptBannerPatternTagProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptBiomeTagProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptBlockTagProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptEntityTagProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptItemTagProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptPaintingVariantTagsProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptStructureTagsProvider;
import com.rosemods.windswept.core.data.server.tags.WindsweptTrimMaterialTagsProvider;
import com.rosemods.windswept.core.other.WindsweptBlockInfo;
import com.rosemods.windswept.core.other.WindsweptCauldronInteractions;
import com.rosemods.windswept.core.other.WindsweptCreativeTabs;
import com.rosemods.windswept.core.other.WindsweptDataProcessors;
import com.rosemods.windswept.core.other.WindsweptDispenseBehaviors;
import com.rosemods.windswept.core.other.WindsweptVillagerTypes;
import com.rosemods.windswept.core.registry.WindsweptAttributes;
import com.rosemods.windswept.core.registry.WindsweptBannerPatterns;
import com.rosemods.windswept.core.registry.WindsweptEffects;
import com.rosemods.windswept.core.registry.WindsweptEnchantments;
import com.rosemods.windswept.core.registry.WindsweptFeatures;
import com.rosemods.windswept.core.registry.WindsweptFoliagePlacers;
import com.rosemods.windswept.core.registry.WindsweptPaintingVariants;
import com.rosemods.windswept.core.registry.WindsweptParticleTypes;
import com.rosemods.windswept.core.registry.WindsweptPotPatterns;
import com.rosemods.windswept.core.registry.WindsweptTreeDecorators;
import com.rosemods.windswept.core.registry.WindsweptTrunkPlacers;
import com.rosemods.windswept.core.registry.util.EffectSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="windswept")
public class Windswept {
    public static final String MOD_ID = "windswept";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"windswept", h -> h.putSubHelper(ForgeRegistries.MOB_EFFECTS, (ISubRegistryHelper)new EffectSubRegistryHelper((RegistryHelper)h)));

    public Windswept() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        WindsweptDataProcessors.registerData();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        WindsweptTreeDecorators.DECORATORS.register(bus);
        WindsweptFoliagePlacers.FOLIAGE_PLACERS.register(bus);
        WindsweptFeatures.FEATURES.register(bus);
        WindsweptEnchantments.ENCHANTMENTS.register(bus);
        WindsweptAttributes.ATTRIBUTES.register(bus);
        WindsweptBannerPatterns.BANNER_PATTERNS.register(bus);
        WindsweptTrunkPlacers.TRUNK_PLACERS.register(bus);
        WindsweptPaintingVariants.PAINTING_VARIANTS.register(bus);
        WindsweptParticleTypes.PARTICLE_TYPES.register(bus);
        WindsweptPotPatterns.DECORATED_POT_PATTERNS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::dataSetup);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WindsweptConfig.COMMON_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)WindsweptConfig.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            WindsweptVillagerTypes.registerVillagerTypes();
            WindsweptBlockInfo.changeLocalisation();
            WindsweptBlockInfo.registerCompostables();
            WindsweptBlockInfo.registerFlammables();
            WindsweptEffects.registerPotionRecipes();
            WindsweptDispenseBehaviors.registerDispenseBehaviors();
            WindsweptCauldronInteractions.registerCauldronInteractions();
            WindsweptCreativeTabs.setupTabEditors();
            WindsweptPotPatterns.registerPatterns();
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        gen.addProvider(client, (DataProvider)new WindsweptSoundProvider(event));
        gen.addProvider(client, (DataProvider)new WindsweptLangProvider(event));
        gen.addProvider(client, (DataProvider)new WindsweptModelProvider(event));
        gen.addProvider(client, (DataProvider)new WindsweptSplashProvider(event));
        gen.addProvider(client, (DataProvider)new WindsweptParticleProvider(event));
        gen.addProvider(client, (DataProvider)new WindsweptSpriteSourceProvider(event));
        WindsweptDatapackProvider dataPack = new WindsweptDatapackProvider(event);
        gen.addProvider(server, (DataProvider)dataPack);
        WindsweptBlockTagProvider blockTags = new WindsweptBlockTagProvider(event, dataPack);
        gen.addProvider(server, (DataProvider)blockTags);
        gen.addProvider(server, (DataProvider)new WindsweptItemTagProvider(event, blockTags, dataPack));
        gen.addProvider(server, (DataProvider)new WindsweptEntityTagProvider(event, dataPack));
        gen.addProvider(server, (DataProvider)new WindsweptBiomeTagProvider(event, dataPack));
        gen.addProvider(server, (DataProvider)new WindsweptStructureTagsProvider(event, dataPack));
        gen.addProvider(server, (DataProvider)new WindsweptTrimMaterialTagsProvider(event, dataPack));
        gen.addProvider(server, (DataProvider)new WindsweptBannerPatternTagProvider(event, dataPack));
        gen.addProvider(server, (DataProvider)new WindsweptLootTableProvider(event));
        gen.addProvider(server, (DataProvider)new WindsweptRecipeProvider(event));
        gen.addProvider(server, (DataProvider)new WindsweptAdvancementModifierProvider(event, dataPack));
        gen.addProvider(server, (DataProvider)new WindsweptLootModifierProvider(event, dataPack));
        gen.addProvider(server, (DataProvider)new WindsweptPaintingVariantTagsProvider(event, dataPack));
        gen.addProvider(server, (DataProvider)new WindsweptChunkGeneratorModifierProvider(event, dataPack));
    }

    public static ResourceLocation location(String id) {
        return new ResourceLocation(MOD_ID, id);
    }
}

