/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.levelgen.tree.trunk_placer;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rosemods.windswept.core.WindsweptConfig;
import com.rosemods.windswept.core.registry.WindsweptBlocks;
import com.rosemods.windswept.core.registry.WindsweptTrunkPlacers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class ChestnutTrunkPlacer
extends TrunkPlacer {
    public static final Codec<ChestnutTrunkPlacer> CODEC = RecordCodecBuilder.create(placer -> ChestnutTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)placer).apply((Applicative)placer, ChestnutTrunkPlacer::new));

    public ChestnutTrunkPlacer() {
        super(0, 0, 0);
    }

    private ChestnutTrunkPlacer(int a, int b, int c) {
        this();
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)WindsweptTrunkPlacers.CHESTNUT_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> consumer, RandomSource rand, int height, BlockPos pos, TreeConfiguration config) {
        int z;
        int x;
        ArrayList list = Lists.newArrayList();
        int h = rand.m_216339_(3, 5);
        list.add(new FoliagePlacer.FoliageAttachment(pos.m_7918_(0, h + 2, 0), 0, false));
        for (int y = 1; y < h; ++y) {
            this.m_226187_(level, consumer, rand, pos.m_6630_(y), config);
        }
        ArrayList raisedX = Lists.newArrayList();
        ArrayList raisedZ = Lists.newArrayList();
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                if (x != 0 && z != 0) continue;
                int y = h;
                int finalX = x;
                int finalZ = z;
                if (Math.abs(x) == 2 || Math.abs(z) == 2) {
                    int posX = x;
                    int posZ = z;
                    int posY = ++y;
                    if (rand.m_188501_() < 0.4f) {
                        boolean success = false;
                        if (x != 0 && rand.m_188499_()) {
                            posX += x > 0 ? 1 : -1;
                            success = true;
                        } else if (z != 0 && rand.m_188499_()) {
                            posZ += z > 0 ? 1 : -1;
                            success = true;
                        }
                        if (success && rand.m_188503_(5) == 0) {
                            ++posY;
                            if (x != 0) {
                                raisedX.add((int)Math.signum(x));
                            } else {
                                raisedZ.add((int)Math.signum(z));
                            }
                        }
                        this.m_226175_(level, consumer, rand, pos.m_7918_(posX, posY, posZ), config, s -> (BlockState)s.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)(finalX != 0 ? Direction.Axis.X : Direction.Axis.Z)));
                    }
                    list.add(new FoliagePlacer.FoliageAttachment(pos.m_7918_(posX, posY, posZ), 0, false));
                }
                this.m_226175_(level, consumer, rand, pos.m_7918_(x, y, z), config, s -> finalX != 0 || finalZ != 0 ? (BlockState)s.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)(finalX != 0 ? Direction.Axis.X : Direction.Axis.Z)) : s);
            }
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                if (x != 0 && z != 0) continue;
                this.m_226187_(level, consumer, rand, pos.m_7918_(x, 0, z), config);
                int grassCheck = -1;
                if (level.m_7433_(pos.m_7918_(x, -1, z), state -> !state.m_280296_())) {
                    this.m_226187_(level, consumer, rand, pos.m_7918_(x, -1, z), config);
                    --grassCheck;
                    if (level.m_7433_(pos.m_7918_(x, -2, z), state -> state.m_247087_()) && ((Boolean)WindsweptConfig.COMMON.roots.get()).booleanValue()) {
                        consumer.accept(pos.m_7918_(x, -2, z), Blocks.f_152548_.m_49966_());
                    }
                }
                if (raisedX.contains(x) || raisedZ.contains(z) || rand.m_188503_(32) == 0) {
                    this.m_226187_(level, consumer, rand, pos.m_7918_(x, 1, z), config);
                }
                if (!level.m_7433_(pos.m_7918_(x, grassCheck, z), state -> state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50599_) || state.m_60713_(Blocks.f_50195_) || state.m_60713_((Block)WindsweptBlocks.GELISOL.get()))) continue;
                ChestnutTrunkPlacer.m_226169_((LevelSimulatedReader)level, consumer, (RandomSource)rand, (BlockPos)pos.m_7918_(x, grassCheck, z), (TreeConfiguration)config);
            }
        }
        return list;
    }
}

