/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.whimsydeco.util;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

@Immutable
public class MultiblockHandler {
    public static final Direction ORIGIN_DIRECTION = Direction.NORTH;
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String DEPTH = "depth";
    protected static final IntegerProperty WIDTH_1_2 = IntegerProperty.m_61631_((String)"width", (int)1, (int)2);
    protected static final IntegerProperty WIDTH_0_2 = IntegerProperty.m_61631_((String)"width", (int)0, (int)2);
    protected static final IntegerProperty HEIGHT_1_2 = IntegerProperty.m_61631_((String)"height", (int)1, (int)2);
    protected static final IntegerProperty HEIGHT_0_2 = IntegerProperty.m_61631_((String)"height", (int)0, (int)2);
    protected static final IntegerProperty DEPTH_1_2 = IntegerProperty.m_61631_((String)"depth", (int)1, (int)2);
    protected static final IntegerProperty DEPTH_0_2 = IntegerProperty.m_61631_((String)"depth", (int)0, (int)2);
    protected static final IntegerProperty[] WIDTH_BY_MAX_VALUE = new IntegerProperty[]{null, WIDTH_1_2, WIDTH_0_2};
    protected static final IntegerProperty[] HEIGHT_BY_MAX_VALUE = new IntegerProperty[]{null, HEIGHT_1_2, HEIGHT_0_2};
    protected static final IntegerProperty[] DEPTH_BY_MAX_VALUE = new IntegerProperty[]{null, DEPTH_1_2, DEPTH_0_2};
    @Nullable
    protected final IntegerProperty widthProperty;
    @Nullable
    protected final IntegerProperty heightProperty;
    @Nullable
    protected final IntegerProperty depthProperty;
    protected final Vec3i dimensions;
    protected final Vec3i minIndex;
    protected final Vec3i maxIndex;
    protected final Map<Direction, BoundingBox> bounds;

    public MultiblockHandler(int width, int height, int depth) {
        if (width < 1 || height < 1 || depth < 1) {
            throw new IllegalArgumentException(String.format("[MultiblockHandler] width, height, and depth must be greater than zero! Provided [{}, {}, {}]", width, height, depth));
        }
        this.dimensions = new Vec3i(width, height, depth);
        this.minIndex = new Vec3i(-(width - 1) / 2, -(height - 1) / 2, -(depth - 1) / 2);
        this.maxIndex = new Vec3i(width / 2, height / 2, depth / 2);
        this.widthProperty = MultiblockHandler.getWidthProperty(width);
        this.heightProperty = MultiblockHandler.getHeightProperty(height);
        this.depthProperty = MultiblockHandler.getDepthProperty(depth);
        BoundingBox boundingBox = BoundingBox.m_162375_((Vec3i)this.minIndex, (Vec3i)this.maxIndex);
        this.bounds = MultiblockHandler.createRotatedBoundingBoxMap(boundingBox, ORIGIN_DIRECTION);
    }

    @Nullable
    public static IntegerProperty getWidthProperty(int maxWidth) {
        int index = Mth.m_14045_((int)(maxWidth - 1), (int)0, (int)(WIDTH_BY_MAX_VALUE.length - 1));
        return WIDTH_BY_MAX_VALUE[index];
    }

    @Nullable
    public static IntegerProperty getHeightProperty(int maxHeight) {
        int index = Mth.m_14045_((int)(maxHeight - 1), (int)0, (int)(HEIGHT_BY_MAX_VALUE.length - 1));
        return HEIGHT_BY_MAX_VALUE[index];
    }

    @Nullable
    public static IntegerProperty getDepthProperty(int maxDepth) {
        int index = Mth.m_14045_((int)(maxDepth - 1), (int)0, (int)(DEPTH_BY_MAX_VALUE.length - 1));
        return DEPTH_BY_MAX_VALUE[index];
    }

    protected static Map<Direction, BoundingBox> createRotatedBoundingBoxMap(BoundingBox boundingBox, Direction from) {
        EnumMap<Direction, BoundingBox> map = new EnumMap<Direction, BoundingBox>(Direction.class);
        map.put(from, boundingBox);
        BoundingBox box = boundingBox;
        for (int i = 0; i < 3; ++i) {
            Direction direction = Direction.m_122407_((int)(from.m_122416_() + i + 1));
            box = new BoundingBox(1 - box.m_162401_(), box.m_162396_(), box.m_162395_(), 1 - box.m_162398_(), box.m_162400_(), box.m_162399_());
            map.put(direction, box);
        }
        return map;
    }
}

