/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watervision.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.net.URI;
import java.util.Collection;
import me.srrapero720.watervision.WaterVision;
import me.srrapero720.watervision.WaterVisionClient;
import me.srrapero720.watervision.common.network.PlayVideoOverlayPacket;
import me.srrapero720.watervision.common.network.PlayVideoPacket;
import me.srrapero720.watervision.common.network.StopVideoOverlayPacket;
import me.srrapero720.watervision.common.network.StopVideoPacket;
import me.srrapero720.watervision.common.network.VisionNetwork;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VisionCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"playvideo").requires(source -> !source.m_230897_() || source.m_6761_(4))).then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(VisionCommands::openVideoScreen)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"volume", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(VisionCommands::openVideoScreen)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.25f, (float)2.0f)).executes(VisionCommands::openVideoScreen)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"stretch_video", (ArgumentType)BoolArgumentType.bool()).executes(VisionCommands::openVideoScreen)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"game_fade_duration", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).executes(VisionCommands::openVideoScreen)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"video_fade_duration", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).executes(VisionCommands::openVideoScreen)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"allow_controls", (ArgumentType)BoolArgumentType.bool()).executes(VisionCommands::openVideoScreen)).then(Commands.m_82129_((String)"allow_exit", (ArgumentType)BoolArgumentType.bool()).executes(VisionCommands::openVideoScreen)))))))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stopvideo").requires(source -> !source.m_230897_() || source.m_6761_(4))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(VisionCommands::stopVideo)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"playoverlay").requires(source -> !source.m_230897_() || source.m_6761_(4))).then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(VisionCommands::openVideoOverlay))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stopoverlay").requires(source -> !source.m_230897_() || source.m_6761_(4))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(VisionCommands::closeVideoOverlay)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerClient(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"playvideoclient").requires(source -> source.m_81373_() != null)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).executes(VisionCommands::openVideoScreenClient)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"volume", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(VisionCommands::openVideoScreenClient)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.25f, (float)2.0f)).executes(VisionCommands::openVideoScreenClient)).then(Commands.m_82129_((String)"stretch_video", (ArgumentType)BoolArgumentType.bool()).executes(VisionCommands::openVideoScreenClient))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"playoverlayclient").requires(source -> source.m_81373_() != null)).then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).executes(VisionCommands::openVideoOverlayClient)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stopoverlayclient").requires(source -> source.m_81373_() != null)).executes(VisionCommands::closeVideoOverlayClient));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int openVideoScreenClient(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            String url = StringArgumentType.getString(context, (String)"url");
            int volume = VisionCommands.getIntOrDefault(context, "volume", 100);
            float speed = VisionCommands.getFloatOrDefault(context, "speed", 1.0f);
            boolean stretchVideo = VisionCommands.getBoolOrDefault(context, "stretch_video", false);
            WaterVisionClient.openScreen(URI.create(url), volume, speed, stretchVideo, 20.0f, 20.0f, true, true);
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to open video screen, see log for more details"));
            WaterVision.LOGGER.error("Failed to execute /playvideoclient command", (Throwable)e);
            return 1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int openVideoOverlayClient(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            String url = StringArgumentType.getString(context, (String)"url");
            WaterVisionClient.openOverlay(URI.create(url));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to open video screen, see console for more details"));
            WaterVision.LOGGER.error("Failed to execute /playoverlay command", (Throwable)e);
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            return 1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int closeVideoOverlayClient(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            WaterVisionClient.closeOverlay();
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to open video screen, see console for more details"));
            WaterVision.LOGGER.error("Failed to execute /playoverlay command", (Throwable)e);
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            return 1;
        }
    }

    private static int openVideoScreen(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            String url = StringArgumentType.getString(context, (String)"url");
            Collection players = EntityArgument.m_91477_(context, (String)"target");
            int volume = VisionCommands.getIntOrDefault(context, "volume", 100);
            float speed = VisionCommands.getFloatOrDefault(context, "speed", 1.0f);
            boolean stretchVideo = VisionCommands.getBoolOrDefault(context, "stretch_video", false);
            float gameFadeDuration = VisionCommands.getFloatOrDefault(context, "game_fade_duration", 20.0f);
            float videoFadeDuration = VisionCommands.getFloatOrDefault(context, "video_fade_duration", 20.0f);
            boolean allowControls = VisionCommands.getBoolOrDefault(context, "allow_controls", true);
            boolean exit = VisionCommands.getBoolOrDefault(context, "allow_exit", true);
            for (ServerPlayer player : players) {
                VisionNetwork.sendTo(new PlayVideoPacket(url, volume, speed, stretchVideo, gameFadeDuration, videoFadeDuration, allowControls, exit), player);
            }
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to open video screen, see console for more details"));
            WaterVision.LOGGER.error("Failed to execute /playvideo command", (Throwable)e);
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            return 1;
        }
    }

    private static int openVideoOverlay(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            String url = StringArgumentType.getString(context, (String)"url");
            Collection players = EntityArgument.m_91477_(context, (String)"target");
            for (ServerPlayer player : players) {
                VisionNetwork.sendTo(new PlayVideoOverlayPacket(url), player);
            }
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to open video screen, see console for more details"));
            WaterVision.LOGGER.error("Failed to execute /playoverlay command", (Throwable)e);
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            return 1;
        }
    }

    private static int closeVideoOverlay(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            Collection players = EntityArgument.m_91477_(context, (String)"target");
            for (ServerPlayer player : players) {
                VisionNetwork.sendTo(new StopVideoOverlayPacket(), player);
            }
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to open video screen, see console for more details"));
            WaterVision.LOGGER.error("Failed to execute /playoverlay command", (Throwable)e);
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            return 1;
        }
    }

    private static int stopVideo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            Collection players = EntityArgument.m_91477_(context, (String)"target");
            for (ServerPlayer player : players) {
                VisionNetwork.sendTo(new StopVideoPacket(), player);
            }
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to open video screen, see console for more details"));
            WaterVision.LOGGER.error("Failed to execute /playoverlay command", (Throwable)e);
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            return 1;
        }
    }

    private static String getStringOrDefault(CommandContext<CommandSourceStack> context, String name, String def) {
        try {
            return StringArgumentType.getString(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    private static int getIntOrDefault(CommandContext<CommandSourceStack> context, String name, int def) {
        try {
            return IntegerArgumentType.getInteger(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    private static float getFloatOrDefault(CommandContext<CommandSourceStack> context, String name, float def) {
        try {
            return FloatArgumentType.getFloat(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    private static boolean getBoolOrDefault(CommandContext<CommandSourceStack> context, String name, boolean def) {
        try {
            return BoolArgumentType.getBool(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }
}

