/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.tools;

public enum AudioFormat {
    U8_MONO_44("U8", 1, 44100, 8),
    U8_STEREO_44("U8", 2, 44100, 8),
    U8_SURROUND_44("U8", 6, 44100, 8),
    U8_SURROUND71_44("U8", 8, 44100, 8),
    S16N_MONO_44("S16N", 1, 44100, 16),
    S16N_STEREO_44("S16N", 2, 44100, 16),
    S16N_SURROUND_44("S16N", 6, 44100, 16),
    S16N_SURROUND71_44("S16N", 8, 44100, 16),
    S16N_MONO_48("S16N", 1, 48000, 16),
    S16N_STEREO_48("S16N", 2, 48000, 16),
    S16N_SURROUND_48("S16N", 6, 48000, 16),
    S16N_SURROUND71_48("S16N", 8, 48000, 16),
    S16N_MONO_96("S16N", 1, 96000, 16),
    S16N_STEREO_96("S16N", 2, 96000, 16),
    S16N_SURROUND_96("S16N", 6, 96000, 16),
    S16N_SURROUND71_96("S16N", 8, 96000, 16),
    S32N_MONO_44("S32N", 1, 44100, 32),
    S32N_STEREO_44("S32N", 2, 44100, 32),
    S32N_SURROUND_44("S32N", 6, 44100, 32),
    S32N_SURROUND71_44("S32N", 8, 44100, 32),
    S32N_MONO_48("S32N", 1, 48000, 32),
    S32N_STEREO_48("S32N", 2, 48000, 32),
    S32N_SURROUND_48("S32N", 6, 48000, 32),
    S32N_SURROUND71_48("S32N", 8, 48000, 32),
    S32N_MONO_96("S32N", 1, 96000, 32),
    S32N_STEREO_96("S32N", 2, 96000, 32),
    S32N_SURROUND_96("S32N", 6, 96000, 32),
    S32N_SURROUND71_96("S32N", 8, 96000, 32),
    FL32_MONO_44("FL32", 1, 44100, 32),
    FL32_STEREO_44("FL32", 2, 44100, 32),
    FL32_SURROUND_44("FL32", 6, 44100, 32),
    FL32_SURROUND71_44("FL32", 8, 44100, 32),
    FL32_MONO_48("FL32", 1, 48000, 32),
    FL32_STEREO_48("FL32", 2, 48000, 32),
    FL32_SURROUND_48("FL32", 6, 48000, 32),
    FL32_SURROUND71_48("FL32", 8, 48000, 32),
    FL32_MONO_96("FL32", 1, 96000, 32),
    FL32_STEREO_96("FL32", 2, 96000, 32),
    FL32_SURROUND_96("FL32", 6, 96000, 32),
    FL32_SURROUND71_96("FL32", 8, 96000, 32);

    private final String formatName;
    private final int channelCount;
    private final int sampleRate;
    private final int bitsPerSample;

    private AudioFormat(String formatName, int channelCount, int sampleRate, int bitsPerSample) {
        this.formatName = formatName;
        this.channelCount = channelCount;
        this.sampleRate = sampleRate;
        this.bitsPerSample = bitsPerSample;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public int calculateBufferSize(int sampleCount) {
        return sampleCount * this.channelCount * (this.bitsPerSample / 8);
    }
}

