/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.component;

import com.sun.jna.Platform;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.factory.MediaPlayerFactory;
import org.watermedia.videolan4j.player.base.MediaPlayer;
import org.watermedia.videolan4j.player.component.InputEvents;
import org.watermedia.videolan4j.player.component.MediaPlayerComponent;
import org.watermedia.videolan4j.player.component.MediaPlayerComponentBase;
import org.watermedia.videolan4j.player.component.MediaPlayerComponentDefaults;
import org.watermedia.videolan4j.player.component.MediaPlayerSpecs;
import org.watermedia.videolan4j.player.component.callback.CallbackImagePainter;
import org.watermedia.videolan4j.player.component.callback.ScaledCallbackImagePainter;
import org.watermedia.videolan4j.player.embedded.EmbeddedMediaPlayer;
import org.watermedia.videolan4j.player.embedded.fullscreen.FullScreenStrategy;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferCleanupCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormat;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormatCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormatCallbackAdapter;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.RenderCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.RenderCallbackAdapter;
import org.watermedia.videolan4j.tools.Chroma;

public class CallbackMediaPlayerComponent
extends MediaPlayerComponentBase
implements MediaPlayerComponent {
    static final String[] DEFAULT_FACTORY_ARGUMENTS = MediaPlayerComponentDefaults.EMBEDDED_MEDIA_PLAYER_ARGS;
    private final boolean ownFactory;
    protected final MediaPlayerFactory mediaPlayerFactory;
    private final DefaultRenderCallback defaultRenderCallback;
    private CallbackImagePainter imagePainter;
    private final EmbeddedMediaPlayer mediaPlayer;
    private BufferedImage image;

    public CallbackMediaPlayerComponent(MediaPlayerFactory mediaPlayerFactory, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, boolean lockBuffers, CallbackImagePainter imagePainter, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback, BufferCleanupCallback cleanupCallback) {
        this.ownFactory = mediaPlayerFactory == null;
        this.mediaPlayerFactory = this.initMediaPlayerFactory(mediaPlayerFactory);
        this.validateArguments(imagePainter, renderCallback, bufferFormatCallback, cleanupCallback);
        if (renderCallback == null) {
            this.defaultRenderCallback = new DefaultRenderCallback();
            this.imagePainter = imagePainter == null ? new ScaledCallbackImagePainter() : imagePainter;
            bufferFormatCallback = new DefaultBufferFormatCallback();
            renderCallback = this.defaultRenderCallback;
        } else {
            this.defaultRenderCallback = null;
            this.imagePainter = null;
            renderCallback = this.init$buildClassLoaderSafeCallback(renderCallback);
        }
        this.mediaPlayer = this.mediaPlayerFactory.mediaPlayers().newEmbeddedMediaPlayer();
        this.mediaPlayer.fullScreen().strategy(fullScreenStrategy);
        this.mediaPlayer.events().addMediaPlayerEventListener(this);
        this.mediaPlayer.events().addMediaEventListener(this);
        bufferFormatCallback = this.init$buildClassLoaderSafeCallback(bufferFormatCallback);
        this.mediaPlayer.videoSurface().set(this.mediaPlayerFactory.videoSurfaces().newVideoSurface(bufferFormatCallback, renderCallback, lockBuffers, cleanupCallback));
        this.initInputEvents(inputEvents);
        this.onAfterConstruct();
    }

    private BufferFormatCallback init$buildClassLoaderSafeCallback(final BufferFormatCallback cb) {
        return new BufferFormatCallback(){

            @Override
            public void allocatedBuffers(ByteBuffer[] buffers) {
                VideoLan4J.checkClassLoader(CallbackMediaPlayerComponent.this.mediaPlayer.getClassLoader());
                cb.allocatedBuffers(buffers);
            }

            @Override
            public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
                VideoLan4J.checkClassLoader(CallbackMediaPlayerComponent.this.mediaPlayer.getClassLoader());
                return cb.getBufferFormat(sourceWidth, sourceHeight);
            }
        };
    }

    private RenderCallback init$buildClassLoaderSafeCallback(RenderCallback cb) {
        return (mediaPlayer, nativeBuffers, bufferFormat) -> {
            VideoLan4J.checkClassLoader(mediaPlayer.getClassLoader());
            cb.display(mediaPlayer, nativeBuffers, bufferFormat);
        };
    }

    public CallbackMediaPlayerComponent(MediaPlayerFactory mediaPlayerFactory, boolean lockBuffers, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback, BufferCleanupCallback cleanupCallback) {
        this(mediaPlayerFactory, null, null, lockBuffers, null, renderCallback, bufferFormatCallback, cleanupCallback);
    }

    public CallbackMediaPlayerComponent(MediaPlayerFactory mediaPlayerFactory, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, boolean lockBuffers, CallbackImagePainter imagePainter) {
        this(mediaPlayerFactory, fullScreenStrategy, inputEvents, lockBuffers, imagePainter, null, null, null);
    }

    public CallbackMediaPlayerComponent(MediaPlayerFactory mediaPlayerFactory, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, boolean lockBuffers, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback, BufferCleanupCallback cleanupCallback) {
        this(mediaPlayerFactory, fullScreenStrategy, inputEvents, lockBuffers, null, renderCallback, bufferFormatCallback, cleanupCallback);
    }

    public CallbackMediaPlayerComponent(MediaPlayerSpecs.CallbackMediaPlayerSpec spec) {
        this(spec.factory, spec.fullScreenStrategy, spec.inputEvents, spec.lockedBuffers, spec.imagePainter, spec.renderCallback, spec.bufferFormatCallback, spec.cleanupCallback);
    }

    public CallbackMediaPlayerComponent(String ... libvlcArgs) {
        this(new MediaPlayerFactory(libvlcArgs), null, null, true, null, null, null, null);
    }

    public CallbackMediaPlayerComponent() {
        this(null, null, null, true, null, null, null, null);
    }

    private void validateArguments(CallbackImagePainter imagePainter, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback, BufferCleanupCallback cleanupCallback) {
        if (renderCallback == null) {
            if (bufferFormatCallback != null) {
                throw new IllegalArgumentException("Do not specify bufferFormatCallback without a renderCallback");
            }
            if (cleanupCallback != null) {
                throw new IllegalArgumentException("Do not specify cleanupCallback without a renderCallback");
            }
        } else {
            if (imagePainter != null) {
                throw new IllegalArgumentException("Do not specify imagePainter with a renderCallback");
            }
            if (bufferFormatCallback == null) {
                throw new IllegalArgumentException("bufferFormatCallback is required with a renderCallback");
            }
        }
    }

    private MediaPlayerFactory initMediaPlayerFactory(MediaPlayerFactory mediaPlayerFactory) {
        if (mediaPlayerFactory == null) {
            mediaPlayerFactory = new MediaPlayerFactory(DEFAULT_FACTORY_ARGUMENTS);
        }
        return mediaPlayerFactory;
    }

    private void initInputEvents(InputEvents inputEvents) {
        if (inputEvents == null) {
            inputEvents = Platform.isLinux() || Platform.isMac() ? InputEvents.DEFAULT : InputEvents.DISABLE_NATIVE;
        }
        switch (inputEvents) {
            case NONE: {
                break;
            }
            case DISABLE_NATIVE: {
                this.mediaPlayer.input().enableKeyInputHandling(false);
                this.mediaPlayer.input().enableMouseInputHandling(false);
            }
        }
    }

    public final void setImagePainter(CallbackImagePainter imagePainter) {
        this.imagePainter = imagePainter;
    }

    public final EmbeddedMediaPlayer mediaPlayer() {
        return this.mediaPlayer;
    }

    public final void release() {
        this.onBeforeRelease();
        this.mediaPlayer.release();
        if (this.ownFactory) {
            this.mediaPlayerFactory.release();
        }
        this.onAfterRelease();
    }

    @Override
    public final MediaPlayerFactory mediaPlayerFactory() {
        return this.mediaPlayerFactory;
    }

    private void newVideoBuffer(int width, int height) {
        this.image = new BufferedImage(width, height, 1);
        this.defaultRenderCallback.setImageBuffer(this.image);
    }

    protected void onPaintOverlay(Graphics2D g2) {
    }

    private static class DefaultRenderCallback
    extends RenderCallbackAdapter {
        private DefaultRenderCallback() {
        }

        private void setImageBuffer(BufferedImage image) {
            this.setBuffer(((DataBufferInt)image.getRaster().getDataBuffer()).getData());
        }

        @Override
        protected void onDisplay(MediaPlayer mediaPlayer, int[] buffer) {
        }
    }

    private class DefaultBufferFormatCallback
    extends BufferFormatCallbackAdapter {
        private DefaultBufferFormatCallback() {
        }

        @Override
        public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
            CallbackMediaPlayerComponent.this.newVideoBuffer(sourceWidth, sourceHeight);
            return new BufferFormat(Chroma.RV32, sourceWidth, sourceHeight);
        }
    }
}

