/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.player;

import com.sun.jna.Platform;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;
import org.watermedia.api.WaterMediaAPI;
import org.watermedia.core.tools.DataTool;
import org.watermedia.core.tools.IOTool;
import org.watermedia.core.tools.JarTool;
import org.watermedia.loaders.ILoader;
import org.watermedia.videolan4j.discovery.NativeDiscovery;
import org.watermedia.videolan4j.discovery.providers.IProvider;
import org.watermedia.videolan4j.factory.MediaPlayerFactory;

public class PlayerAPI
extends WaterMediaAPI {
    private static final Marker IT = MarkerManager.getMarker((String)PlayerAPI.class.getSimpleName());
    public static final Map<String, MediaPlayerFactory> FACTORIES = new LinkedHashMap<String, MediaPlayerFactory>();
    private final Path dir;
    private final String zipInput;
    private final String configInput;
    private final File zipOutput;
    private final File configOutput;
    private boolean extract = false;
    private final boolean wrapped = Platform.isWindows() && Platform.is64Bit();

    public static boolean isReady() {
        return NativeDiscovery.discovered();
    }

    public static MediaPlayerFactory getFactory() {
        return FACTORIES.get(WaterMedia.asResource("default"));
    }

    public static MediaPlayerFactory getFactory(String resourceLocation) {
        return FACTORIES.get(resourceLocation);
    }

    public static MediaPlayerFactory getFactorySoundOnly() {
        return FACTORIES.get(WaterMedia.asResource("sound_only"));
    }

    public static synchronized MediaPlayerFactory registerFactory(String id, String[] vlcArgs) {
        if (NativeDiscovery.start()) {
            MediaPlayerFactory factory = new MediaPlayerFactory(vlcArgs);
            MediaPlayerFactory oldFactory = FACTORIES.put(id, factory);
            WaterMedia.LOGGER.info(IT, "Created new VLC instance with ID '{}' with args: '{}'", (Object)id, (Object)Arrays.toString(vlcArgs));
            if (oldFactory != null) {
                WaterMedia.LOGGER.warn(IT, "Factory {} previously defined was overwritten", (Object)id);
                oldFactory.release();
            }
            return factory;
        }
        WaterMedia.LOGGER.fatal(IT, "[VLC IS MISSING]: Cannot create MediaPlayerFactory instance");
        return null;
    }

    public PlayerAPI() {
        ILoader bootstrap = WaterMedia.getLoader();
        String zFilename = "win-x64.zip";
        this.dir = bootstrap.tempDir().resolve("videolan");
        this.zipInput = "videolan/" + zFilename;
        this.configInput = "videolan/version.cfg";
        if (this.wrapped) {
            this.zipOutput = this.dir.resolve(zFilename).toFile();
            this.configOutput = this.dir.resolve("version.cfg").toFile();
        } else {
            this.configOutput = null;
            this.zipOutput = null;
        }
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.HIGH;
    }

    @Override
    public boolean prepare(ILoader bootCore) throws Exception {
        WaterMedia.LOGGER.info(IT, "Binaries are {}", (Object)(this.wrapped ? "wrapped" : "not wrapped"));
        if (WaterMedia.NO_VLC.getAsBoolean()) {
            WaterMedia.LOGGER.warn(IT, "Detected {}, skipping PlayerAPI loading", (Object)WaterMedia.NO_VLC);
            return false;
        }
        if (this.wrapped) {
            boolean hasExtracted;
            String versionInJar = JarTool.readString(this.configInput);
            String versionInFile = IOTool.readString(this.configOutput);
            boolean versionMatch = versionInFile != null && versionInFile.equalsIgnoreCase(versionInJar);
            File[] f = this.zipOutput.getParentFile().listFiles();
            boolean bl = hasExtracted = f != null && f.length > 4;
            if (!versionMatch) {
                this.extract = true;
                WaterMedia.LOGGER.info(IT, "Binaries extraction scheduled");
                if (this.zipOutput.getParentFile().exists()) {
                    WaterMedia.LOGGER.warn(IT, "Old installation detected, cleaning it...");
                    if (IOTool.rmdirs(this.zipOutput.getParentFile())) {
                        WaterMedia.LOGGER.info(IT, "Cleanup successfully");
                    } else {
                        WaterMedia.LOGGER.error("Failed to delete old installation");
                    }
                }
            } else if (!hasExtracted) {
                this.extract = true;
                WaterMedia.LOGGER.warn(IT, "Binaries extraction scheduled due to a broken or missing installation");
            } else {
                WaterMedia.LOGGER.warn(IT, "VLC binaries extraction skipped. Extracted version match with wrapped version");
            }
        } else {
            WaterMedia.LOGGER.warn(IT, "[NOT A BUG] {} doesn't contains VLC binaries for your OS and ARCH, you had to download it manually from 'https://www.videolan.org/vlc/'", (Object)"WATERMeDIA");
        }
        return true;
    }

    @Override
    public void start(ILoader bootCore) throws Exception {
        if (this.extract) {
            WaterMedia.LOGGER.info(IT, "Extracting VideoLAN binaries...");
            if (!this.zipOutput.exists() && JarTool.copyAsset(this.zipInput, this.zipOutput.toPath()) || this.zipOutput.exists()) {
                IOTool.unzip(this.zipOutput.toPath());
                if (!this.zipOutput.delete()) {
                    WaterMedia.LOGGER.error(IT, "Failed to delete binaries zip file...");
                }
                JarTool.copyAsset(this.configInput, this.configOutput.toPath());
                WaterMedia.LOGGER.info(IT, "VideoLAN binaries extracted successfully");
            } else {
                WaterMedia.LOGGER.error(IT, "Failed to extract VideoLAN binaries");
            }
        }
        try {
            String[] args = JarTool.readArray(Platform.isWindows() ? "videolan/arguments.json" : "videolan/arguments_linux.json");
            PlayerAPI.registerFactory(WaterMedia.asResource("default"), args);
            PlayerAPI.registerFactory(WaterMedia.asResource("sound_only"), DataTool.concat(args, "--vout=none"));
            Runtime.getRuntime().addShutdownHook(new Thread(this::release));
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Failed to load VLC", (Throwable)e);
        }
    }

    @Override
    public void release() {
        FACTORIES.forEach((s, mediaPlayerFactory) -> mediaPlayerFactory.release());
        FACTORIES.clear();
    }

    public static class Provider
    implements IProvider {
        @Override
        public String name() {
            return "WaterMedia Provider";
        }

        @Override
        public IProvider.Priority priority() {
            return IProvider.Priority.HIGHEST;
        }

        @Override
        public boolean supported() {
            return Platform.isWindows() && Platform.is64Bit();
        }

        @Override
        public String[] directories() {
            return new String[]{WaterMedia.getLoader().tempDir().resolve("videolan").toAbsolutePath().toString()};
        }
    }

    public static class ConfigProvider
    implements IProvider {
        private static final File customPathFile = WaterMedia.getConfigDir().resolve("custom_vlc_path.txt").toFile();
        private String content;

        public ConfigProvider() {
            if (!customPathFile.exists()) {
                IOTool.writeData(customPathFile, new byte[0]);
            }
        }

        @Override
        public String name() {
            return "WaterMedia Config Provider";
        }

        @Override
        public IProvider.Priority priority() {
            return IProvider.Priority.OVERWRITE;
        }

        @Override
        public boolean supported() {
            if (this.content == null) {
                this.content = IOTool.readString(customPathFile);
            }
            if (this.content == null || this.content.isEmpty()) {
                return false;
            }
            File f = new File(this.content);
            return f.exists() && f.isDirectory();
        }

        @Override
        public String[] directories() {
            return new String[]{this.content};
        }
    }
}

