/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.screens.styles.IconStyles;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.joml.Matrix4f;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.simple.GuiIcon;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.util.math.geo.Rect;

public class WidgetClickableArea
extends GuiIcon {
    private PositionHorizontal x;
    private PositionVertical y;
    private boolean selected = false;

    public WidgetClickableArea(String name, PositionHorizontal x, PositionVertical y) {
        super(name, IconStyles.POS_BASE);
        this.x = x;
        this.y = y;
    }

    protected void renderContent(GuiGraphics guiGraphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        PoseStack pose = guiGraphics.m_280168_();
        super.renderContent(guiGraphics, control, rect, mouseX, mouseY);
        this.renderSelector(pose, control, rect, mouseX, mouseY);
    }

    protected void renderSelector(PoseStack pose, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        Icon icon = IconStyles.POS_ICON;
        float width = (float)rect.getWidth() / 3.0f;
        float height = (float)rect.getWidth() / 3.0f;
        float offsetX = switch (this.x) {
            default -> throw new IncompatibleClassChangeError();
            case PositionHorizontal.LEFT -> 0.0f;
            case PositionHorizontal.CENTER -> width;
            case PositionHorizontal.RIGHT -> (float)((double)width * 2.0);
        };
        float offsetY = switch (this.y) {
            default -> throw new IncompatibleClassChangeError();
            case PositionVertical.TOP -> 0.0f;
            case PositionVertical.CENTER -> height;
            case PositionVertical.BOTTOM -> (float)((double)height * 2.0);
        };
        pose.m_85836_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon.location());
        this.color.glColor();
        Matrix4f matrix = pose.m_85850_().m_252922_();
        float x = offsetX;
        float x2 = offsetX + width;
        float y = offsetY;
        float y2 = offsetY + height;
        float u = (float)icon.minX() / 256.0f;
        float v = (float)icon.minY() / 256.0f;
        float u2 = (float)(icon.minX() + icon.width()) / 256.0f;
        float v2 = (float)(icon.minY() + icon.height()) / 256.0f;
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, x, y2, 0.0f).m_7421_(u, v2).m_5752_();
        bufferbuilder.m_252986_(matrix, x2, y2, 0.0f).m_7421_(u2, v2).m_5752_();
        bufferbuilder.m_252986_(matrix, x2, y, 0.0f).m_7421_(u2, v).m_5752_();
        bufferbuilder.m_252986_(matrix, x, y, 0.0f).m_7421_(u, v).m_5752_();
        Tesselator.m_85913_().m_85914_();
        RenderSystem.disableBlend();
        pose.m_85849_();
    }

    public boolean mouseClicked(Rect rect, double mouseX, double mouseY, int button) {
        WidgetClickableArea.playSound((Holder.Reference)SoundEvents.f_12490_);
        this.selected = true;
        this.mouseMoved(rect, mouseX, mouseY);
        return true;
    }

    public void mouseMoved(Rect rect, double mouseX, double mouseY) {
        super.mouseMoved(rect, mouseX, mouseY);
        if (this.selected) {
            int areaX = (int)(mouseX / rect.getWidth() * 3.0);
            int areaY = (int)(mouseY / rect.getHeight() * 3.0);
            this.x = switch (areaX) {
                case 0 -> PositionHorizontal.LEFT;
                case 1 -> PositionHorizontal.CENTER;
                case 2, 3 -> PositionHorizontal.RIGHT;
                default -> areaX > 3 ? PositionHorizontal.RIGHT : PositionHorizontal.LEFT;
            };
            this.y = switch (areaY) {
                case 0 -> PositionVertical.TOP;
                case 1 -> PositionVertical.CENTER;
                case 2, 3 -> PositionVertical.BOTTOM;
                default -> areaY > 3 ? PositionVertical.BOTTOM : PositionVertical.TOP;
            };
        }
    }

    public void mouseReleased(Rect rect, double x, double y, int button) {
        this.selected = false;
        super.mouseReleased(rect, x, y, button);
    }

    public List<Component> getTooltip() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add((Component)WidgetClickableArea.translatable((String)"waterframes.gui.position.desc"));
        tooltips.add((Component)WidgetClickableArea.translatable((String)"waterframes.gui.position.vertical", (Object[])new Object[]{ChatFormatting.AQUA + WidgetClickableArea.translate((String)("waterframes.gui.position." + this.y.name().toLowerCase()))}));
        tooltips.add((Component)WidgetClickableArea.translatable((String)"waterframes.gui.position.horizontal", (Object[])new Object[]{ChatFormatting.AQUA + WidgetClickableArea.translate((String)("waterframes.gui.position." + this.x.name().toLowerCase()))}));
        return tooltips;
    }

    public PositionHorizontal getX() {
        return this.x;
    }

    public PositionVertical getY() {
        return this.y;
    }
}

