/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block;

import me.srrapero720.waterframes.DisplaysRegistry;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.entity.TvTile;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;

@MethodsReturnNonnullByDefault
public class TvBlock
extends DisplayBlock {
    @Override
    public DirectionProperty getFacing() {
        return BlockStateProperties.f_61374_;
    }

    @Override
    public PermissionNode<Boolean> getPermissionNode() {
        return DisplaysRegistry.PERM_DISPLAYS_INTERACT_TV;
    }

    public static AlignedBox box(Direction direction, Direction attachedBlockFace, boolean renderMode) {
        float renderMargin;
        Facing facing = Facing.get((Direction)direction.m_122424_());
        Facing wide = Facing.get((Direction)attachedBlockFace);
        AlignedBox box = new AlignedBox();
        float f = renderMargin = renderMode ? 1.0f : 0.0f;
        if (attachedBlockFace == direction) {
            if (facing.positive) {
                box.setMax(facing.axis, 0.75f);
                box.setMin(facing.axis, 0.625f);
            } else {
                box.setMax(facing.axis, 0.375f);
                box.setMin(facing.axis, 0.25f);
            }
        } else if (attachedBlockFace.m_122424_() == direction) {
            if (facing.positive) {
                box.setMax(facing.axis, 0.9375f);
                box.setMin(facing.axis, 0.8125f);
            } else {
                box.setMax(facing.axis, 0.1875f);
                box.setMin(facing.axis, 0.0625f);
            }
        } else if (attachedBlockFace == Direction.UP) {
            if (facing.positive) {
                box.setMax(facing.axis, 0.375f);
                box.setMin(facing.axis, 0.25f);
            } else {
                box.setMax(facing.axis, 0.75f);
                box.setMin(facing.axis, 0.625f);
            }
        } else if (facing.positive) {
            box.setMax(facing.axis, -0.0625f);
            box.setMin(facing.axis, -0.1875f);
        } else {
            box.setMax(facing.axis, 1.1875f);
            box.setMin(facing.axis, 1.0625f);
        }
        Axis one = facing.one();
        Axis two = facing.two();
        if (facing.axis != Axis.Z) {
            one = facing.two();
            two = facing.one();
        }
        if (attachedBlockFace == Direction.DOWN) {
            box.setMax(two, (12.0f - renderMargin) / 16.0f);
            box.setMin(two, -((9.0f - renderMargin) / 16.0f));
        } else if (attachedBlockFace == Direction.UP) {
            box.setMax(two, (24.0f - renderMargin) / 16.0f);
            box.setMin(two, (3.0f + renderMargin) / 16.0f);
        } else if (attachedBlockFace.m_122424_() == direction || attachedBlockFace == direction) {
            box.setMax(two, (19.0f - renderMargin) / 16.0f);
            box.setMin(two, (-2.0f + renderMargin) / 16.0f);
        } else {
            box.setMax(two, (19.0f - renderMargin) / 16.0f);
            box.setMin(two, (-2.0f + renderMargin) / 16.0f);
        }
        if (attachedBlockFace == Direction.DOWN || attachedBlockFace == Direction.UP) {
            box.setMax(one, (25.0f - renderMargin) / 16.0f);
            box.setMin(one, 1.0f - (25.0f - renderMargin) / 16.0f);
        } else if (attachedBlockFace.m_122424_() == direction || attachedBlockFace == direction) {
            box.setMax(one, (25.0f - renderMargin) / 16.0f);
            box.setMin(one, 1.0f - (25.0f - renderMargin) / 16.0f);
        } else if (wide.positive) {
            box.setMax(one, (32.0f - renderMargin) / 16.0f);
            box.setMin(one, (-2.0f + renderMargin) / 16.0f);
        } else {
            box.setMax(one, (18.0f - renderMargin) / 16.0f);
            box.setMin(one, -((16.0f - renderMargin) / 16.0f));
        }
        if (!renderMode) {
            box.scale(1.01f);
        }
        return box;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return TvBlock.box((Direction)state.m_61143_((Property)this.getFacing()), (Direction)state.m_61143_((Property)ATTACHED_FACE), false).voxelShape();
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState st = super.m_5573_(context);
        return (BlockState)st.m_61124_((Property)this.getFacing(), (Comparable)((Direction)st.m_61143_((Property)this.getFacing())).m_122424_());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TvTile(pos, state);
    }
}

