/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.rawlxxxviii.visual_keybinder.screen;

import com.gmail.rawlxxxviii.visual_keybinder.KeybindingPreset;
import com.gmail.rawlxxxviii.visual_keybinder.ui_list.KeyPresetOptionsList;
import com.gmail.rawlxxxviii.visual_keybinder.util.FileUtil;
import com.mojang.blaze3d.platform.InputConstants;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.settings.KeyModifier;

public class PresetsScreen
extends OptionsSubScreen {
    private EditBox newPresetNameEditBox;
    private Button saveNewPresetButton;
    private KeyPresetOptionsList KeyPresetOptionsList;

    public PresetsScreen(Screen screen, Options options) {
        super(screen, options, (Component)Component.m_237113_((String)"Keybinding presets"));
    }

    protected void m_7856_() {
        int uiWidth = 400;
        int uiLeft = this.f_96543_ / 2 - uiWidth / 2;
        int uiRight = uiLeft + this.f_96543_;
        int uiTop = 40;
        int bottomPadding = 50;
        int uiHeight = this.f_96544_ - uiTop - bottomPadding;
        int uiBottom = uiTop + uiHeight;
        this.m_142416_((GuiEventListener)new Button.Builder(CommonComponents.f_130655_, button -> this.m_7379_()).m_252794_(this.f_96543_ / 2 - 75, this.f_96544_ - 25).m_253046_(150, 20).m_253136_());
        this.newPresetNameEditBox = (EditBox)this.m_7787_((GuiEventListener)new EditBox(this.f_96547_, uiLeft + 1, uiTop, uiWidth - 100 - 10, 20, (Component)Component.m_237113_((String)"new preset name")));
        this.saveNewPresetButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"Save preset"), button -> this.savePreset(this.newPresetNameEditBox.m_94155_())).m_252794_(this.newPresetNameEditBox.m_252754_() + this.newPresetNameEditBox.m_5711_() + 10, uiTop).m_253046_(100, 20).m_253136_());
        this.KeyPresetOptionsList = (KeyPresetOptionsList)this.m_7787_((GuiEventListener)new KeyPresetOptionsList(this, this.f_96541_, this.f_96282_, uiLeft, uiTop + 30, uiWidth, uiHeight - 30));
    }

    public void savePreset(String name) {
        if ((name = FileUtil.sanitizeString(name)).isBlank()) {
            return;
        }
        try {
            FileUtil.savePreset(this.f_96282_, name);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.m_232761_();
    }

    public void deletePreset(String name) {
        try {
            FileUtil.deletePreset(name);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.m_232761_();
    }

    public void loadPreset(String name) {
        try {
            FileUtil.loadPreset(this.f_96282_, name);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.m_232761_();
    }

    public void unbindAll() {
        for (KeyMapping keymapping : this.f_96282_.f_92059_) {
            keymapping.setKeyModifierAndCode(KeyModifier.NONE, InputConstants.f_84822_);
            this.f_96282_.m_92159_(keymapping, InputConstants.f_84822_);
        }
        this.f_96282_.m_92169_();
        KeyMapping.m_90854_();
        this.m_232761_();
    }

    public void resetAll() {
        for (KeyMapping keymapping : this.f_96282_.f_92059_) {
            keymapping.setToDefault();
            this.f_96282_.m_92159_(keymapping, keymapping.m_90861_());
        }
        this.f_96282_.m_92169_();
        KeyMapping.m_90854_();
        this.m_232761_();
    }

    public void m_86600_() {
        this.newPresetNameEditBox.m_94120_();
    }

    public void m_7522_(@Nullable GuiEventListener p_94677_) {
        GuiEventListener currentFocused = this.m_7222_();
        if (currentFocused instanceof EditBox) {
            EditBox editBox = (EditBox)currentFocused;
            if (!currentFocused.equals(p_94677_)) {
                editBox.m_93692_(false);
            }
        }
        super.m_7522_(p_94677_);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float p_193994_) {
        this.m_280039_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 16, 0xFFFFFF);
        this.saveNewPresetButton.m_88315_(guiGraphics, mouseX, mouseY, p_193994_);
        this.newPresetNameEditBox.m_88315_(guiGraphics, mouseX, mouseY, p_193994_);
        if (this.newPresetNameEditBox.m_94155_().isEmpty()) {
            guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"Preset name"), this.newPresetNameEditBox.m_252754_() + 4, this.newPresetNameEditBox.m_252907_() + 6, Color.darkGray.getRGB());
        }
        this.KeyPresetOptionsList.m_88315_(guiGraphics, mouseX, mouseY, p_193994_);
        super.m_88315_(guiGraphics, mouseX, mouseY, p_193994_);
    }

    public boolean isPresetActive(KeybindingPreset keybindingPreset) {
        if (this.f_96282_.f_92059_.length != keybindingPreset.getLines().size()) {
            return false;
        }
        for (KeyMapping keymapping : this.f_96282_.f_92059_) {
            KeyModifier keyModifier = null;
            InputConstants.Key key = null;
            String mappingName = keymapping.m_90860_();
            List<String> list = keybindingPreset.getLines().stream().filter(x -> x.startsWith(mappingName + ":")).toList();
            if (list.isEmpty()) {
                return false;
            }
            String presetValue = list.get(0).substring(mappingName.length() + 1);
            if (presetValue.indexOf(58) != -1) {
                String[] pts = presetValue.split(":");
                keyModifier = KeyModifier.valueFromString((String)pts[1]);
                key = InputConstants.m_84851_((String)pts[0]);
            } else {
                keyModifier = KeyModifier.NONE;
                key = InputConstants.m_84851_((String)presetValue);
            }
            if (key.equals((Object)keymapping.getKey()) || key.equals((Object)InputConstants.f_84822_) || keyModifier == keymapping.getKeyModifier()) continue;
            return false;
        }
        return true;
    }

    public boolean hasNonDefaultBindings() {
        for (KeyMapping keymapping : this.f_96282_.f_92059_) {
            if (keymapping.m_90864_()) continue;
            return true;
        }
        return false;
    }

    public boolean hasBoundBindings() {
        for (KeyMapping keymapping : this.f_96282_.f_92059_) {
            if (keymapping.m_90862_()) continue;
            return true;
        }
        return false;
    }
}

