/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.registries.ModBlockStateProperties;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingMossBlock
extends Block
implements BonemealableBlock {
    private static final VoxelShape TIP_SHAPE = Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty TIP = ModBlockStateProperties.TIP;

    public HangingMossBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)TIP, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)TIP) != false ? TIP_SHAPE : BASE_SHAPE;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockState aboveState;
        if (random.m_188503_(500) == 0 && ((aboveState = level.m_8055_(pos.m_7494_())).m_204336_(ModBlockTags.PALE_OAK_LOGS) || aboveState.m_60713_(ModBlocks.PALE_OAK_LEAVES.get()))) {
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSoundEvents.PALE_HANGING_MOSS_IDLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.canStayAtPosition((BlockGetter)level, pos);
    }

    private boolean canStayAtPosition(BlockGetter level, BlockPos pos) {
        BlockState aboveState;
        BlockPos above = pos.m_7494_();
        return MultifaceBlock.m_153829_((BlockGetter)level, (Direction)Direction.UP, (BlockPos)above, (BlockState)(aboveState = level.m_8055_(above))) || aboveState.m_60713_(ModBlocks.PALE_HANGING_MOSS.get());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!this.canStayAtPosition((BlockGetter)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        return (BlockState)state.m_61124_((Property)TIP, (Comparable)Boolean.valueOf(!level.m_8055_(pos.m_7495_()).m_60713_((Block)this)));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.canStayAtPosition((BlockGetter)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TIP});
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return this.canGrowInto(level.m_8055_(this.getTip((BlockGetter)level, pos).m_7495_()));
    }

    private boolean canGrowInto(BlockState state) {
        return state.m_60795_();
    }

    public BlockPos getTip(BlockGetter level, BlockPos pos) {
        BlockState state;
        BlockPos.MutableBlockPos position = pos.m_122032_();
        do {
            position.m_122173_(Direction.DOWN);
        } while ((state = level.m_8055_((BlockPos)position)).m_60713_((Block)this));
        return position.m_121945_(Direction.UP).m_7949_();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos tipPos = this.getTip((BlockGetter)level, pos).m_7495_();
        if (this.canGrowInto(level.m_8055_(tipPos))) {
            level.m_46597_(tipPos, (BlockState)state.m_61124_((Property)TIP, (Comparable)Boolean.valueOf(true)));
        }
    }
}

