/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.unusualfishmod.common.entity.util.base;

import codyhuh.unusualfishmod.common.entity.CrimsonshellSquid;
import codyhuh.unusualfishmod.common.entity.TrumpetSquid;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public abstract class BreedableWaterAnimal
extends WaterAnimal {
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(BreedableWaterAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_GRAVID = SynchedEntityData.m_135353_(BreedableWaterAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int age;
    protected int forcedAge;
    protected int forcedAgeTimer;
    private int inLove;
    @Nullable
    private UUID loveCause;

    protected BreedableWaterAnimal(EntityType<? extends WaterAnimal> p_146738_, Level p_146739_) {
        super(p_146738_, p_146739_);
    }

    public boolean isGravid() {
        return (Boolean)this.f_19804_.m_135370_(DATA_GRAVID);
    }

    public void setGravid(boolean gravid) {
        this.f_19804_.m_135381_(DATA_GRAVID, (Object)gravid);
    }

    @Nullable
    public abstract BreedableWaterAnimal getBreedOffspring(ServerLevel var1, BreedableWaterAnimal var2);

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BABY_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_GRAVID, (Object)false);
    }

    public int getAge() {
        if (this.m_9236_().f_46443_) {
            return (Boolean)this.f_19804_.m_135370_(DATA_BABY_ID) != false ? -1 : 1;
        }
        return this.age;
    }

    public void ageUp(int p_146741_, boolean p_146742_) {
        int i = this.getAge();
        if ((i += p_146741_ * 20) > 0) {
            i = 0;
        }
        int j = i - i;
        this.setAge(i);
        if (p_146742_) {
            this.forcedAge += j;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getAge() == 0) {
            this.setAge(this.forcedAge);
        }
    }

    public void ageUp(int p_146759_) {
        this.ageUp(p_146759_, false);
    }

    public void setAge(int p_146763_) {
        int i = this.getAge();
        this.age = p_146763_;
        if (i < 0 && p_146763_ >= 0 || i >= 0 && p_146763_ < 0) {
            this.f_19804_.m_135381_(DATA_BABY_ID, (Object)(p_146763_ < 0 ? 1 : 0));
            this.ageBoundaryReached();
        }
    }

    protected void m_8024_() {
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        super.m_8024_();
    }

    public boolean m_6469_(DamageSource p_27567_, float p_27568_) {
        if (this.m_6673_(p_27567_)) {
            return false;
        }
        this.inLove = 0;
        return super.m_6469_(p_27567_, p_27568_);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Age", this.getAge());
        tag.m_128405_("ForcedAge", this.forcedAge);
        tag.m_128405_("InLove", this.inLove);
        if (this.loveCause != null) {
            tag.m_128362_("LoveCause", this.loveCause);
        }
        tag.m_128379_("Gravid", this.isGravid());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAge(tag.m_128451_("Age"));
        this.forcedAge = tag.m_128451_("ForcedAge");
        this.inLove = tag.m_128451_("InLove");
        this.loveCause = tag.m_128403_("LoveCause") ? tag.m_128342_("LoveCause") : null;
        this.setGravid(tag.m_128471_("Gravid"));
    }

    public void m_7350_(EntityDataAccessor<?> p_146754_) {
        if (DATA_BABY_ID.equals(p_146754_)) {
            this.m_6210_();
        }
        super.m_7350_(p_146754_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.m_6084_()) {
            int i = this.getAge();
            if (i < 0) {
                this.setAge(++i);
            } else if (i > 0) {
                this.setAge(--i);
            }
        }
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        }
    }

    protected void ageBoundaryReached() {
    }

    public boolean m_6162_() {
        return this.getAge() < 0;
    }

    public void m_6863_(boolean p_146756_) {
        this.setAge(p_146756_ ? -24000 : 0);
    }

    public static int getSpeedUpSecondsWhenFeeding(int p_216968_) {
        return (int)((float)(p_216968_ / 20) * 0.1f);
    }

    public void m_7822_(byte p_27562_) {
        if (p_27562_ == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        } else {
            super.m_7822_(p_27562_);
        }
    }

    protected void usePlayerItem(Player p_148715_, InteractionHand p_148716_, ItemStack p_148717_) {
        if (!p_148715_.m_150110_().f_35937_) {
            p_148717_.m_41774_(1);
        }
    }

    public boolean canFallInLove() {
        return this.inLove <= 0;
    }

    public void setInLove(@Nullable Player p_27596_) {
        this.inLove = 600;
        if (p_27596_ != null) {
            this.loveCause = p_27596_.m_20148_();
        }
        this.m_9236_().m_7605_((Entity)this, (byte)18);
    }

    @Nullable
    public ServerPlayer getLoveCause() {
        if (this.loveCause == null) {
            return null;
        }
        Player player = this.m_9236_().m_46003_(this.loveCause);
        return player instanceof ServerPlayer ? (ServerPlayer)player : null;
    }

    public int m_8100_() {
        return 120;
    }

    public boolean m_6785_(double p_27598_) {
        return false;
    }

    public int m_213860_() {
        return 1 + this.m_9236_().f_46441_.m_188503_(3);
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.m_150930_(Items.f_42405_);
    }

    public InteractionResult m_6071_(Player p_27584_, InteractionHand p_27585_) {
        ItemStack itemstack = p_27584_.m_21120_(p_27585_);
        if (this.isFood(itemstack)) {
            int i = this.getAge();
            if (!this.m_9236_().f_46443_ && i == 0 && this.canFallInLove()) {
                this.usePlayerItem(p_27584_, p_27585_, itemstack);
                this.setInLove(p_27584_);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.usePlayerItem(p_27584_, p_27585_, itemstack);
                this.ageUp(BreedableWaterAnimal.getSpeedUpSecondsWhenFeeding(-i), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(p_27584_, p_27585_);
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void resetLove() {
        this.inLove = 0;
    }

    public boolean canMate(BreedableWaterAnimal p_27569_) {
        if (p_27569_ == this) {
            return false;
        }
        if (((Object)((Object)p_27569_)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.isInLove() && p_27569_.isInLove();
    }

    public void spawnChildFromBreeding(ServerLevel p_27564_, BreedableWaterAnimal animal) {
        BreedableWaterAnimal ageable = this.getBreedOffspring(p_27564_, animal);
        if (animal instanceof CrimsonshellSquid || animal instanceof TrumpetSquid) {
            this.setAge(6000);
            animal.setAge(6000);
            this.resetLove();
            animal.resetLove();
            animal.setGravid(true);
            return;
        }
        if (ageable != null) {
            ServerPlayer serverplayer = this.getLoveCause();
            if (serverplayer == null && animal.getLoveCause() != null) {
                serverplayer = animal.getLoveCause();
            }
            if (serverplayer != null) {
                serverplayer.m_36220_(Stats.f_12937_);
            }
            this.setAge(6000);
            animal.setAge(6000);
            this.resetLove();
            animal.resetLove();
            ageable.m_6863_(true);
            ageable.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            p_27564_.m_47205_((Entity)ageable);
            p_27564_.m_7605_((Entity)this, (byte)18);
            if (p_27564_.m_46469_().m_46207_(GameRules.f_46135_)) {
                p_27564_.m_7967_((Entity)new ExperienceOrb((Level)p_27564_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_217043_().m_188503_(7) + 1));
            }
        }
    }

    public static class AgeableWaterAnimalGroupData
    implements SpawnGroupData {
        private int groupSize;
        private final boolean shouldSpawnBaby;
        private final float babySpawnChance;

        private AgeableWaterAnimalGroupData(boolean p_146775_, float p_146776_) {
            this.shouldSpawnBaby = p_146775_;
            this.babySpawnChance = p_146776_;
        }

        public AgeableWaterAnimalGroupData(boolean p_146773_) {
            this(p_146773_, 0.05f);
        }

        public AgeableWaterAnimalGroupData(float p_146771_) {
            this(true, p_146771_);
        }

        public int getGroupSize() {
            return this.groupSize;
        }

        public void increaseGroupSizeByOne() {
            ++this.groupSize;
        }

        public boolean isShouldSpawnBaby() {
            return this.shouldSpawnBaby;
        }

        public float getBabySpawnChance() {
            return this.babySpawnChance;
        }
    }
}

