/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.unusualfishmod.common.entity;

import codyhuh.unusualfishmod.common.entity.util.goal.CustomSwellGoal;
import codyhuh.unusualfishmod.common.entity.util.misc.UFAnimations;
import codyhuh.unusualfishmod.core.registry.UFSounds;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Rootball
extends Monster
implements GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(Rootball.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(Rootball.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private float explosionRadius = 1.5f;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Rootball(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new CustomSwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.4, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 2.0);
    }

    public int m_6056_() {
        return this.m_5448_() == null ? 3 : 3 + (int)(this.m_21223_() - 1.0f);
    }

    public boolean m_142535_(float p_149687_, float p_149688_, DamageSource p_149689_) {
        boolean flag = super.m_142535_(p_149687_, p_149688_, p_149689_);
        this.swell = (int)((float)this.swell + p_149687_ * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return flag;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("Fuse", (short)this.maxSwell);
        compound.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        compound.m_128379_("ignited", this.isIgnited());
    }

    public void m_7378_(CompoundTag p_32296_) {
        super.m_7378_(p_32296_);
        if (p_32296_.m_128425_("Fuse", 99)) {
            this.maxSwell = p_32296_.m_128448_("Fuse");
        }
        if (p_32296_.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = p_32296_.m_128445_("ExplosionRadius");
        }
        if (p_32296_.m_128471_("ignited")) {
            this.ignite();
        }
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.m_8119_();
    }

    public void m_6710_(@Nullable LivingEntity p_149691_) {
        if (!(p_149691_ instanceof Goat)) {
            super.m_6710_(p_149691_);
        }
    }

    protected SoundEvent m_7975_(DamageSource p_32309_) {
        return SoundEvents.f_11836_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11835_;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UFSounds.SMALL_ENEMY.get();
    }

    public boolean m_7327_(Entity p_32281_) {
        return true;
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    private void explodeCreeper() {
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionRadius, Level.ExplosionInteraction.MOB);
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.m_9236_().m_7967_((Entity)areaeffectcloud);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    public static boolean canSpawn(EntityType<Rootball> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || iServerWorld.m_45527_(pos.m_7494_()) && Rootball.canMonsterSpawnInLight(entityType, iServerWorld, reason, pos, random);
    }

    public static boolean canMonsterSpawnInLight(EntityType<? extends Rootball> p_223325_0_, ServerLevelAccessor p_223325_1_, MobSpawnType p_223325_2_, BlockPos p_223325_3_, RandomSource p_223325_4_) {
        return Rootball.isValidLightLevel(p_223325_1_, p_223325_3_, p_223325_4_) && Rootball.m_217057_(p_223325_0_, (LevelAccessor)p_223325_1_, (MobSpawnType)p_223325_2_, (BlockPos)p_223325_3_, (RandomSource)p_223325_4_);
    }

    public static boolean isValidLightLevel(ServerLevelAccessor p_223323_0_, BlockPos p_223323_1_, RandomSource p_223323_2_) {
        int light = p_223323_0_.m_46803_(p_223323_1_);
        return light <= 4;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (this.m_20069_()) {
            if (event.isMoving()) {
                event.setAnimation(UFAnimations.WALK);
            } else {
                event.setAnimation(UFAnimations.IDLE);
            }
        } else {
            event.setAnimation(UFAnimations.FLOP);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

