/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.init.forge;

import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.untitledduckmod.DuckMod;
import net.untitledduckmod.common.init.forge.ModEntityTypesImpl;
import net.untitledduckmod.common.platform.forge.RegistryHelperImpl;

public class ModBiomeModifier
implements BiomeModifier {
    private static final String BIOME_MODIFIER_NAME = "untitled_spawns";
    private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)DuckMod.id("untitled_spawns"), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"untitledduckmod");

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            ModEntityTypesImpl.addBiomeSpawns(biome, builder);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)SERIALIZER.get();
    }

    public static Codec<ModBiomeModifier> makeCodec() {
        return Codec.unit(ModBiomeModifier::new);
    }

    public static void init() {
        RegistryHelperImpl.registerBiomeModifier(BIOME_MODIFIER_NAME, ModBiomeModifier::makeCodec);
    }
}

