/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import trofers.util.JsonHelper;

public record DisplayInfo(float xOffset, float yOffset, float zOffset, float xRotation, float yRotation, float zRotation, float scale) {
    public static final DisplayInfo NONE = new DisplayInfo(1.0f);

    public DisplayInfo(float scale) {
        this(0.0f, 0.0f, 0.0f, scale);
    }

    public DisplayInfo(float xOffset, float yOffset, float zOffset, float scale) {
        this(xOffset, yOffset, zOffset, 0.0f, 0.0f, 0.0f, scale);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.xOffset);
        buffer.writeFloat(this.yOffset);
        buffer.writeFloat(this.zOffset);
        buffer.writeFloat(this.xRotation);
        buffer.writeFloat(this.yRotation);
        buffer.writeFloat(this.zRotation);
        buffer.writeFloat(this.scale);
    }

    public static DisplayInfo fromNetwork(FriendlyByteBuf buffer) {
        return new DisplayInfo(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        if (this.xOffset() != 0.0f || this.yOffset() != 0.0f || this.zOffset() != 0.0f) {
            result.add("offset", (JsonElement)DisplayInfo.serializeVector(this.xOffset(), this.yOffset(), this.zOffset()));
        }
        if (this.xRotation() != 0.0f || this.yRotation() != 0.0f || this.zRotation() != 0.0f) {
            result.add("rotation", (JsonElement)DisplayInfo.serializeVector(this.xRotation(), this.yRotation(), this.zRotation()));
        }
        if (this.scale() != 0.0f) {
            result.addProperty("scale", (Number)Float.valueOf(this.scale()));
        }
        return result;
    }

    private static JsonObject serializeVector(float x, float y, float z) {
        JsonObject result = new JsonObject();
        if (x != 0.0f) {
            result.addProperty("x", (Number)Float.valueOf(x));
        }
        if (y != 0.0f) {
            result.addProperty("y", (Number)Float.valueOf(y));
        }
        if (z != 0.0f) {
            result.addProperty("z", (Number)Float.valueOf(z));
        }
        return result;
    }

    public static DisplayInfo fromJson(JsonObject object) {
        float zOffset = 0.0f;
        float yOffset = 0.0f;
        float xOffset = 0.0f;
        if (object.has("offset")) {
            JsonObject offset = GsonHelper.m_13930_((JsonObject)object, (String)"offset");
            xOffset = JsonHelper.readOptionalFloat(offset, "x", 0);
            yOffset = JsonHelper.readOptionalFloat(offset, "y", 0);
            zOffset = JsonHelper.readOptionalFloat(offset, "z", 0);
        }
        float zRotation = 0.0f;
        float yRotation = 0.0f;
        float xRotation = 0.0f;
        if (object.has("rotation")) {
            JsonObject rotation = GsonHelper.m_13930_((JsonObject)object, (String)"rotation");
            xRotation = JsonHelper.readOptionalFloat(rotation, "x", 0);
            yRotation = JsonHelper.readOptionalFloat(rotation, "y", 0);
            zRotation = JsonHelper.readOptionalFloat(rotation, "z", 0);
        }
        float scale = JsonHelper.readOptionalFloat(object, "scale", 1);
        return new DisplayInfo(xOffset, yOffset, zOffset, xRotation, yRotation, zRotation, scale);
    }
}

