/*
 * Decompiled with CFR 0.152.
 */
package trofers.network;

import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import trofers.trophy.Trophy;
import trofers.trophy.TrophyManager;
import trofers.trophy.TrophySearchTreeManager;

public class TrophySyncPacket {
    private final Map<ResourceLocation, Trophy> trophies;

    public TrophySyncPacket(FriendlyByteBuf buffer) {
        this.trophies = new HashMap<ResourceLocation, Trophy>();
        while (buffer.readBoolean()) {
            Trophy trophy = Trophy.fromNetwork(buffer);
            this.trophies.put(trophy.id(), trophy);
        }
    }

    public TrophySyncPacket(Map<ResourceLocation, Trophy> trophies) {
        this.trophies = trophies;
    }

    void encode(FriendlyByteBuf buffer) {
        this.trophies.values().forEach(trophy -> {
            buffer.writeBoolean(true);
            trophy.toNetwork(buffer);
        });
        buffer.writeBoolean(false);
    }

    void apply(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            TrophyManager.setTrophies(this.trophies);
            TrophySearchTreeManager.createSearchTree();
        });
    }
}

