/*
 * Decompiled with CFR 0.152.
 */
package trofers.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import trofers.Trofers;
import trofers.loot.AbstractLootModifier;
import trofers.trophy.Trophy;
import trofers.trophy.TrophyManager;

public class AddEntityTrophy
extends AbstractLootModifier {
    public static final Supplier<Codec<AddEntityTrophy>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> AddEntityTrophy.codecStart(instance).and((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("trophyBase").forGetter(m -> m.trophyBase)).and((App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)ResourceLocation.f_135803_).fieldOf("trophies").forGetter(m -> m.trophies)).apply((Applicative)instance, AddEntityTrophy::create)));
    private final Item trophyBase;
    private final Map<ResourceLocation, ResourceLocation> trophies;
    private final Set<EntityType<?>> entities;

    private AddEntityTrophy(LootItemCondition[] conditions, Item trophyBase, Map<ResourceLocation, ResourceLocation> trophies, Set<EntityType<?>> entities) {
        super(conditions);
        this.trophyBase = trophyBase;
        this.trophies = trophies;
        this.entities = entities;
    }

    public static AddEntityTrophy create(LootItemCondition[] conditions, ItemLike trophyBase, Map<ResourceLocation, ResourceLocation> trophies, boolean logMissingEntities) {
        HashSet entities = new HashSet();
        for (ResourceLocation entityTypeId : trophies.keySet()) {
            if (BuiltInRegistries.f_256780_.m_7804_(entityTypeId)) {
                entities.add((EntityType)BuiltInRegistries.f_256780_.m_7745_(entityTypeId));
                continue;
            }
            if (!logMissingEntities) continue;
            Trofers.LOGGER.debug("Skipping trophy loot modifier entry for missing entity type " + entityTypeId);
        }
        return new AddEntityTrophy(conditions, trophyBase.m_5456_(), trophies, entities);
    }

    public static AddEntityTrophy create(LootItemCondition[] conditions, ItemLike trophyBase, Map<ResourceLocation, ResourceLocation> trophies) {
        return AddEntityTrophy.create(conditions, trophyBase, trophies, true);
    }

    @Override
    public Codec<? extends AbstractLootModifier> codec() {
        return CODEC.get();
    }

    @Override
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation trophyId;
        EntityType entityTypeId;
        if (context.m_78936_(LootContextParams.f_81455_) && this.entities.contains(entityTypeId = ((Entity)context.m_165124_(LootContextParams.f_81455_)).m_6095_()) && (trophyId = this.trophies.get(BuiltInRegistries.f_256780_.m_7981_((Object)entityTypeId))) != null) {
            Trophy trophy = TrophyManager.get(trophyId);
            if (trophy == null) {
                Trofers.LOGGER.error("Failed to find trophy with invalid id '{}'", (Object)trophyId);
            } else {
                generatedLoot.add((Object)trophy.createItem((ItemLike)this.trophyBase));
            }
        }
        return generatedLoot;
    }
}

