/*
 * Decompiled with CFR 0.152.
 */
package trofers.forge;

import java.util.function.Supplier;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import trofers.TrofersClient;
import trofers.block.entity.TrophyBlockEntityRenderer;
import trofers.registry.ModBlockEntityTypes;
import trofers.registry.ModBlocks;
import trofers.trophy.TrophySearchTreeManager;

public class TrofersForgeClient {
    public TrofersForgeClient() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::onBlockColorHandler);
        modEventBus.addListener(this::onItemColorHandler);
        modEventBus.addListener(this::onRegisterClientReloadListeners);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.TROPHY.get()), TrophyBlockEntityRenderer::new));
    }

    public void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new TrophySearchTreeManager());
    }

    public void onBlockColorHandler(RegisterColorHandlersEvent.Block event) {
        for (Supplier supplier : ModBlocks.TROPHIES) {
            event.register(TrofersClient::getTrophyBlockColor, new Block[]{(Block)supplier.get()});
        }
    }

    public void onItemColorHandler(RegisterColorHandlersEvent.Item event) {
        for (Supplier supplier : ModBlocks.TROPHIES) {
            event.register(TrofersClient::getTrophyItemColor, new ItemLike[]{(ItemLike)supplier.get()});
        }
    }
}

