/*
 * Decompiled with CFR 0.152.
 */
package trofers.block.entity;

import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import trofers.Trofers;
import trofers.block.TrophyBlock;
import trofers.registry.ModBlockEntityTypes;
import trofers.trophy.Trophy;
import trofers.trophy.TrophyManager;
import trofers.trophy.components.EffectInfo;

public class TrophyBlockEntity
extends BlockEntity {
    public static final BlockEntityTicker<TrophyBlockEntity> TICKER = (level, pos, state, blockEntity) -> blockEntity.tick();
    @Nullable
    private ResourceLocation trophyID;
    private int rewardCooldown;
    private float animationOffset;

    public TrophyBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.TROPHY.get(), pos, state);
    }

    @Nullable
    public Trophy getTrophy() {
        return TrophyManager.get(this.trophyID);
    }

    public void setTrophy(@Nullable Trophy trophy) {
        this.trophyID = trophy != null ? trophy.id() : null;
        this.restartRewardCooldown();
        this.onContentsChanged();
    }

    @Nullable
    public ResourceLocation getTrophyID() {
        return this.trophyID;
    }

    public float getAnimationOffset() {
        if (this.animationOffset == 0.0f && this.f_58857_ != null) {
            this.animationOffset = this.f_58857_.m_213780_().m_188501_() * 4000.0f;
        }
        return this.animationOffset;
    }

    public int getTrophyHeight() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof TrophyBlock) {
            TrophyBlock trophy = (TrophyBlock)block;
            return trophy.getHeight();
        }
        return 0;
    }

    public void restartRewardCooldown() {
        Trophy trophy = this.getTrophy();
        this.rewardCooldown = trophy != null && trophy.effects().rewards().cooldown() > 0 ? trophy.effects().rewards().cooldown() : 0;
    }

    public void removeCooldown() {
        this.rewardCooldown = 0;
    }

    public void tick() {
        if (this.rewardCooldown > 0) {
            --this.rewardCooldown;
            if (this.f_58857_ != null) {
                this.f_58857_.m_151543_(this.m_58899_());
            }
        }
    }

    public boolean applyEffect(Player player, InteractionHand hand) {
        Level level;
        Trophy trophy = this.getTrophy();
        if (trophy == null || this.f_58857_ == null) {
            return false;
        }
        EffectInfo.RewardInfo rewards = trophy.effects().rewards();
        EffectInfo.SoundInfo sound = trophy.effects().sound();
        if (sound != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 pos = Vec3.m_82512_((Vec3i)this.m_58899_());
            TrophyBlockEntity.playSound(serverLevel, sound.soundEvent(), pos, sound.volume(), sound.pitch());
        }
        this.giveRewards(rewards, player, hand);
        return sound != null || rewards.lootTable() != null && Trofers.CONFIG.general.enableTrophyLoot != false || !rewards.statusEffect().m_128456_() && Trofers.CONFIG.general.enableTrophyEffects != false;
    }

    private static void playSound(ServerLevel level, ResourceLocation sound, Vec3 pos, float volume, float pitch) {
        double maxDistance = Math.pow(volume > 1.0f ? (double)volume * 16.0 : 16.0, 2.0);
        long seed = level.m_213780_().m_188505_();
        for (ServerPlayer player : level.m_6907_()) {
            double z;
            double y;
            double x = pos.f_82479_ - player.m_20185_();
            double distance = x * x + (y = pos.f_82480_ - player.m_20186_()) * y + (z = pos.f_82481_ - player.m_20189_()) * z;
            if (distance > maxDistance) continue;
            Holder holder = Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)sound));
            player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(holder, SoundSource.BLOCKS, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), volume, pitch, seed));
        }
    }

    private void giveRewards(EffectInfo.RewardInfo rewards, Player player, InteractionHand hand) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (!(Trofers.CONFIG.general.enableTrophyLoot.booleanValue() && rewards.lootTable() != null || Trofers.CONFIG.general.enableTrophyEffects.booleanValue() && !rewards.statusEffect().m_128456_())) {
            return;
        }
        if (this.rewardCooldown > 0) {
            player.m_5661_((Component)Component.m_237110_((String)String.format("message.%s.reward_cooldown", "trofers"), (Object[])new Object[]{this.getTime(this.rewardCooldown)}), true);
            return;
        }
        this.restartRewardCooldown();
        this.rewardLoot(rewards, player, hand);
        this.rewardPotionEffect(rewards, player);
    }

    private Component getTime(int ticks) {
        int seconds = (ticks + 20) / 20;
        if (seconds <= 1) {
            return Component.m_237115_((String)"time.trofers.second");
        }
        if (seconds < 60) {
            return Component.m_237110_((String)"time.trofers.seconds", (Object[])new Object[]{seconds});
        }
        int minutes = seconds / 60;
        if (minutes <= 1) {
            return Component.m_237115_((String)"time.trofers.minute");
        }
        if (minutes < 60) {
            return Component.m_237110_((String)"time.trofers.minutes", (Object[])new Object[]{minutes});
        }
        int hours = minutes / 60;
        if (hours <= 1) {
            return Component.m_237115_((String)"time.trofers.hour");
        }
        return Component.m_237110_((String)"time.trofers.hours", (Object[])new Object[]{hours});
    }

    private void rewardPotionEffect(EffectInfo.RewardInfo rewards, Player player) {
        MobEffectInstance potionEffect;
        if (Trofers.CONFIG.general.enableTrophyEffects.booleanValue() && (potionEffect = rewards.createStatusEffect()) != null) {
            player.m_7292_(potionEffect);
        }
    }

    private void rewardLoot(EffectInfo.RewardInfo rewards, Player player, InteractionHand hand) {
        ResourceLocation lootTableLocation;
        if (Trofers.CONFIG.general.enableTrophyLoot.booleanValue() && (lootTableLocation = rewards.lootTable()) != null) {
            LootTable lootTable = this.f_58857_.m_7654_().m_278653_().m_278676_(lootTableLocation);
            if (lootTable == LootTable.f_79105_) {
                Trofers.LOGGER.log(org.apache.logging.log4j.Level.ERROR, "Invalid loot table: {}", (Object)lootTableLocation);
                return;
            }
            LootParams parameters = this.createLootContext(player, player.m_21120_(hand));
            lootTable.m_287195_(parameters).forEach(this::spawnAtLocation);
        }
    }

    private LootParams createLootContext(Player player, ItemStack stack) {
        return new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81462_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.m_58899_())).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81461_, (Object)this.m_58900_()).m_287286_(LootContextParams.f_81463_, (Object)stack).m_287235_(LootContextParamSets.f_81421_);
    }

    @Nullable
    public void spawnAtLocation(ItemStack stack) {
        if (!stack.m_41619_() && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ItemEntity item = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + (double)this.getTrophyHeight() / 16.0 + 0.2, (double)this.m_58899_().m_123343_() + 0.5, stack);
            item.m_32060_();
            this.f_58857_.m_7967_((Entity)item);
        }
    }

    private void onContentsChanged() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.m_5776_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
                this.m_6596_();
            } else {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            }
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag result = super.m_5995_();
        this.m_183515_(result);
        return result;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag tag) {
        this.loadTrophy(tag);
        this.rewardCooldown = tag.m_128451_("RewardCooldown");
    }

    public void loadTrophy(CompoundTag tag) {
        this.trophyID = null;
        if (tag.m_128425_("Trophy", 8)) {
            try {
                this.trophyID = new ResourceLocation(tag.m_128461_("Trophy"));
            }
            catch (ResourceLocationException exception) {
                Trofers.LOGGER.error(String.format("Failed to load trophy for block entity at %s", this.m_58899_()), (Throwable)exception);
            }
            Trophy trophy = TrophyManager.get(this.trophyID);
            if (trophy == null) {
                Trofers.LOGGER.error(String.format("Invalid trophy id for block entity at %s: %s", this.m_58899_(), this.trophyID));
            }
        }
        if (this.m_58904_() != null && this.m_58904_().m_5776_()) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void m_183515_(CompoundTag tag) {
        if (this.trophyID != null) {
            tag.m_128359_("Trophy", this.trophyID.toString());
        }
        if (this.rewardCooldown > 0) {
            tag.m_128405_("RewardCooldown", this.rewardCooldown);
        }
    }
}

