/*
 * Decompiled with CFR 0.152.
 */
package trofers.block;

import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import trofers.Trofers;
import trofers.block.entity.TrophyBlockEntity;
import trofers.registry.ModBlockEntityTypes;
import trofers.screen.TrophySelectionScreen;
import trofers.trophy.Trophy;

public class TrophyBlock
extends BaseEntityBlock {
    public static final String DESCRIPTION_ID = Util.m_137492_((String)"block", (ResourceLocation)Trofers.id("trophy"));
    private final int height;
    private final VoxelShape shape;

    private TrophyBlock(BlockBehaviour.Properties properties, int height, VoxelShape shape) {
        super(properties);
        this.height = height;
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
    }

    public static TrophyBlock createPillarTrophy(BlockBehaviour.Properties properties, int size) {
        return new TrophyBlock(properties, size, TrophyBlock.createPillarShape(size));
    }

    public static TrophyBlock createPlateTrophy(BlockBehaviour.Properties properties, int size) {
        return new TrophyBlock(properties, 2, TrophyBlock.createPlateShape(size));
    }

    private static VoxelShape createPillarShape(int size) {
        int width = 2 * (size - 2);
        return Shapes.m_83124_((VoxelShape)TrophyBlock.centeredBox(width, 0, 2), (VoxelShape[])new VoxelShape[]{TrophyBlock.centeredBox(width - 2, 2, size - 2), TrophyBlock.centeredBox(width, size - 2, size)});
    }

    private static VoxelShape createPlateShape(int size) {
        int width = 2 * (size - 2);
        return TrophyBlock.m_49796_((double)(8.0 - (double)width / 2.0), (double)0.0, (double)(8.0 - (double)width / 2.0), (double)(8.0 + (double)width / 2.0), (double)2.0, (double)(8.0 + (double)width / 2.0));
    }

    private static VoxelShape centeredBox(int width, int minY, int maxY) {
        return TrophyBlock.m_49796_((double)(8.0 - (double)width / 2.0), (double)minY, (double)(8.0 - (double)width / 2.0), (double)(8.0 + (double)width / 2.0), (double)maxY, (double)(8.0 + (double)width / 2.0));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    public int getHeight() {
        return this.height;
    }

    public String m_7705_() {
        return DESCRIPTION_ID;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        Trophy trophy = Trophy.getTrophy(stack);
        if (trophy != null) {
            tooltip.addAll(trophy.tooltip());
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TrophyBlockEntity) {
            TrophyBlockEntity blockEntity2 = (TrophyBlockEntity)blockEntity;
            if (placer instanceof Player) {
                Player player = (Player)placer;
                if (!level.m_5776_() && player.m_7500_()) {
                    blockEntity2.removeCooldown();
                }
            }
        }
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean isWaterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntityTypes.TROPHY.get()).m_155264_(pos, state);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        TrophyBlockEntity blockEntity;
        ItemStack result = super.m_7397_(level, pos, state);
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof TrophyBlockEntity && (blockEntity = (TrophyBlockEntity)blockEntity2).getTrophyID() != null) {
            result.m_41698_("BlockEntityTag").m_128359_("Trophy", blockEntity.getTrophyID().toString());
        }
        return result;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        TrophyBlockEntity blockEntity;
        if (player.m_7500_()) {
            if (level.m_5776_()) {
                TrophySelectionScreen.open(state, pos);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof TrophyBlockEntity && (blockEntity = (TrophyBlockEntity)blockEntity2).applyEffect(player, hand)) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.m_5776_() ? null : TrophyBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.TROPHY.get()), TrophyBlockEntity.TICKER);
    }
}

