/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.platform.Platform;
import com.tom.storagemod.tile.CraftingTerminalBlockEntity;
import com.tom.storagemod.util.StoredItemStack;
import com.tom.storagemod.util.TerminalSyncManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class TerminalCraftingFiller {
    private CraftingTerminalBlockEntity te;
    private Player player;
    private Int2ObjectMap<List<ItemStack>> allItems = new Int2ObjectOpenHashMap();
    private TerminalSyncManager sync;

    public TerminalCraftingFiller(CraftingTerminalBlockEntity te, Player player, TerminalSyncManager sync) {
        this.te = te;
        this.player = player;
        this.sync = sync;
    }

    public void placeRecipe(Recipe<?> recipe) {
        this.te.clear(this.player);
        this.sync.fillCraftingFiller(this);
        for (ItemStack i : this.player.m_150109_().f_35974_) {
            this.accountStack(i);
        }
        int rw = Platform.getRecipeWidth(recipe);
        if (rw == -1) {
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe sr = (ShapedRecipe)recipe;
                rw = sr.m_44220_();
            } else {
                int cnt = recipe.m_7527_().size();
                rw = cnt == 1 ? 1 : (cnt <= 4 ? 2 : 3);
            }
        }
        NonNullList ings = recipe.m_7527_();
        block1: for (int i = 0; i < ings.size(); ++i) {
            Ingredient ingr = (Ingredient)ings.get(i);
            if (ingr.m_43947_()) continue;
            int x = i % rw;
            int y = i / rw;
            boolean filled = false;
            IntListIterator intListIterator = ingr.m_43931_().iterator();
            while (intListIterator.hasNext()) {
                int v = (Integer)intListIterator.next();
                List lst = (List)this.allItems.get(v);
                if (lst == null) continue;
                for (ItemStack item : lst) {
                    if (!ingr.test(item)) continue;
                    StoredItemStack pull = this.te.pullStack(new StoredItemStack(item), 1L);
                    if (pull != null) {
                        filled = true;
                        this.te.setCraftSlot(x, y, pull.getActualStack());
                        break;
                    }
                    int id = this.player.m_150109_().m_36030_(item);
                    if (id == -1) continue;
                    this.te.setCraftSlot(x, y, this.player.m_150109_().m_7407_(id, 1));
                    filled = true;
                    break;
                }
                if (!filled) continue;
                continue block1;
            }
        }
    }

    public void accountStack(ItemStack st) {
        if (st.m_41788_()) {
            return;
        }
        int index = StackedContents.m_36496_((ItemStack)st);
        ((List)this.allItems.computeIfAbsent(index, __ -> new ArrayList())).add(st);
    }
}

