/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.hrznstudio.titanium.Titanium;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class JSONSerializableDataHandler {
    private static HashMap<Class, Pair<Writer, Reader>> FIELD_SERIALIZER = new HashMap();

    public static <T> void map(Class<T> type, Writer<T> writer, Reader<T> reader) {
        FIELD_SERIALIZER.put(type, (Pair<Writer, Reader>)Pair.of(writer, reader));
    }

    public static boolean acceptField(Field f, Class<?> type) {
        int mods = f.getModifiers();
        return !Modifier.isFinal(mods) && !Modifier.isStatic(mods) && !Modifier.isTransient(mods) && FIELD_SERIALIZER.containsKey(type);
    }

    public static <T> T read(Class<T> type, JsonElement element) {
        return ((Reader)FIELD_SERIALIZER.get(type).getSecond()).read(element);
    }

    public static JsonElement write(Class<?> type, Object value) {
        return ((Writer)FIELD_SERIALIZER.get(type).getFirst()).write(value);
    }

    public static JsonObject writeItemStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        JsonObject object = new JsonObject();
        object.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        object.addProperty("count", (Number)stack.m_41613_());
        if (stack.m_41782_()) {
            object.addProperty("nbt", stack.m_41783_().toString());
        }
        return object;
    }

    public static JsonElement writeFluidStack(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return null;
        }
        return new JsonPrimitive(fluidStack.writeToNBT(new CompoundTag()).toString());
    }

    public static FluidStack readFluidStack(JsonElement object) {
        try {
            return FluidStack.loadFluidStackFromNBT((CompoundTag)TagParser.m_129359_((String)object.getAsString()));
        }
        catch (CommandSyntaxException e) {
            Titanium.LOGGER.catching((Throwable)e);
            return FluidStack.EMPTY;
        }
    }

    public static ItemStack readItemStack(JsonObject object) {
        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(object.get("item").getAsString())), GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1));
        if (object.has("nbt")) {
            try {
                stack.m_41751_(TagParser.m_129359_((String)object.get("nbt").getAsString()));
            }
            catch (CommandSyntaxException e) {
                Titanium.LOGGER.catching((Throwable)e);
            }
        }
        return stack;
    }

    public static JsonObject writeRegistryKey(ResourceKey<?> registryKey) {
        JsonObject object = new JsonObject();
        object.addProperty("key", registryKey.m_211136_().toString());
        object.addProperty("value", registryKey.m_135782_().toString());
        return object;
    }

    public static ResourceKey<?> readRegistryKey(JsonElement object) {
        return ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(object.getAsJsonObject().get("key").getAsString())), (ResourceLocation)new ResourceLocation(object.getAsJsonObject().get("value").getAsString()));
    }

    static {
        JSONSerializableDataHandler.map(Byte.TYPE, JsonPrimitive::new, JsonElement::getAsByte);
        JSONSerializableDataHandler.map(Short.TYPE, JsonPrimitive::new, JsonElement::getAsShort);
        JSONSerializableDataHandler.map(Integer.TYPE, JsonPrimitive::new, JsonElement::getAsInt);
        JSONSerializableDataHandler.map(Long.TYPE, JsonPrimitive::new, JsonElement::getAsLong);
        JSONSerializableDataHandler.map(Float.TYPE, JsonPrimitive::new, JsonElement::getAsFloat);
        JSONSerializableDataHandler.map(Double.TYPE, JsonPrimitive::new, JsonElement::getAsDouble);
        JSONSerializableDataHandler.map(Boolean.TYPE, JsonPrimitive::new, JsonElement::getAsBoolean);
        JSONSerializableDataHandler.map(Character.TYPE, JsonPrimitive::new, JsonElement::getAsCharacter);
        JSONSerializableDataHandler.map(Byte.class, JsonPrimitive::new, JsonElement::getAsByte);
        JSONSerializableDataHandler.map(Short.class, JsonPrimitive::new, JsonElement::getAsShort);
        JSONSerializableDataHandler.map(Integer.class, JsonPrimitive::new, JsonElement::getAsInt);
        JSONSerializableDataHandler.map(Long.class, JsonPrimitive::new, JsonElement::getAsLong);
        JSONSerializableDataHandler.map(Float.class, JsonPrimitive::new, JsonElement::getAsFloat);
        JSONSerializableDataHandler.map(Double.class, JsonPrimitive::new, JsonElement::getAsDouble);
        JSONSerializableDataHandler.map(Boolean.class, JsonPrimitive::new, JsonElement::getAsBoolean);
        JSONSerializableDataHandler.map(Character.class, JsonPrimitive::new, JsonElement::getAsCharacter);
        JSONSerializableDataHandler.map(String.class, JsonPrimitive::new, JsonElement::getAsString);
        JSONSerializableDataHandler.map(ItemStack.class, JSONSerializableDataHandler::writeItemStack, element -> JSONSerializableDataHandler.readItemStack(element.getAsJsonObject()));
        JSONSerializableDataHandler.map(ItemStack[].class, stacks -> {
            JsonArray array = new JsonArray();
            for (ItemStack stack : stacks) {
                array.add((JsonElement)JSONSerializableDataHandler.writeItemStack(stack));
            }
            return array;
        }, element -> {
            JsonArray array = element.getAsJsonArray();
            ItemStack[] stacks = new ItemStack[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                stacks[i] = JSONSerializableDataHandler.readItemStack(array.get(i).getAsJsonObject());
            }
            return stacks;
        });
        JSONSerializableDataHandler.map(ResourceLocation.class, type -> new JsonPrimitive(type.toString()), element -> new ResourceLocation(element.getAsString()));
        JSONSerializableDataHandler.map(Block.class, type -> new JsonPrimitive(ForgeRegistries.BLOCKS.getKey(type).toString()), element -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(element.getAsString())));
        JSONSerializableDataHandler.map(FluidStack.class, JSONSerializableDataHandler::writeFluidStack, JSONSerializableDataHandler::readFluidStack);
        JSONSerializableDataHandler.map(ResourceKey.class, JSONSerializableDataHandler::writeRegistryKey, JSONSerializableDataHandler::readRegistryKey);
        JSONSerializableDataHandler.map(ResourceKey[].class, registryKeys -> {
            JsonObject object = new JsonObject();
            if (((ResourceKey[])registryKeys).length > 0) {
                object.addProperty("type", registryKeys[0].m_211136_().toString());
                JsonArray array = new JsonArray();
                for (ResourceKey registryKey : registryKeys) {
                    array.add(registryKey.m_135782_().toString());
                }
                object.add("values", (JsonElement)array);
            }
            return object;
        }, element -> {
            ResourceKey[] registryKeys = new ResourceKey[]{};
            if (element.getAsJsonObject().has("type")) {
                registryKeys = new ResourceKey[element.getAsJsonObject().getAsJsonArray("values").size()];
                int i = 0;
                for (JsonElement jsonElement : element.getAsJsonObject().getAsJsonArray("values")) {
                    registryKeys[i] = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(element.getAsJsonObject().get("type").getAsString())), (ResourceLocation)new ResourceLocation(jsonElement.getAsString()));
                    ++i;
                }
            }
            return registryKeys;
        });
        JSONSerializableDataHandler.map(Ingredient.class, type -> {
            if (Ingredient.f_43901_.equals(type)) {
                return null;
            }
            return type.m_43942_();
        }, element -> CraftingHelper.getIngredient((JsonElement)element.getAsJsonObject(), (boolean)true));
        JSONSerializableDataHandler.map(Ingredient[].class, type -> {
            JsonArray array = new JsonArray();
            for (Ingredient ingredient : type) {
                array.add(JSONSerializableDataHandler.write(Ingredient.class, ingredient));
            }
            return array;
        }, element -> {
            Ingredient[] ingredients = new Ingredient[element.getAsJsonArray().size()];
            int i = 0;
            for (JsonElement jsonElement : element.getAsJsonArray()) {
                ingredients[i] = JSONSerializableDataHandler.read(Ingredient.class, jsonElement);
                ++i;
            }
            return ingredients;
        });
        JSONSerializableDataHandler.map(Ingredient.Value.class, Ingredient.Value::m_6544_, element -> Ingredient.m_43919_((JsonObject)element.getAsJsonObject()));
        JSONSerializableDataHandler.map(Ingredient.Value[].class, type -> {
            JsonArray array = new JsonArray();
            for (Ingredient.Value ingredient : type) {
                array.add(JSONSerializableDataHandler.write(Ingredient.Value.class, ingredient));
            }
            return array;
        }, element -> {
            Ingredient.Value[] ingredient = new Ingredient.Value[element.getAsJsonArray().size()];
            int i = 0;
            for (JsonElement jsonElement : element.getAsJsonArray()) {
                ingredient[i] = JSONSerializableDataHandler.read(Ingredient.Value.class, jsonElement);
                ++i;
            }
            return ingredient;
        });
        JSONSerializableDataHandler.map(CompoundTag.class, type -> new JsonPrimitive(type.toString()), element -> {
            try {
                return TagParser.m_129359_((String)element.getAsString());
            }
            catch (CommandSyntaxException e) {
                Titanium.LOGGER.catching((Throwable)e);
                return new CompoundTag();
            }
        });
    }

    public static interface Reader<T> {
        public T read(JsonElement var1);
    }

    public static interface Writer<T> {
        public JsonElement write(T var1);
    }
}

