/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import tanukidecor.TDRegistry;
import tanukidecor.block.entity.DIYWorkbenchBlockEntity;
import tanukidecor.network.ServerBoundSelectDIYRecipePacket;
import tanukidecor.network.TDNetwork;
import tanukidecor.recipe.DIYRecipe;

public class DIYWorkbenchMenu
extends AbstractContainerMenu {
    public static final int PLAYER_INV_X = 11;
    public static final int PLAYER_INV_Y = 134;
    private static final int CONTAINER_SLOTS = 4;
    private static final int RESULT_SLOTS = 1;
    private final BlockPos blockPos;
    private final Inventory inventory;
    private final RegistryAccess registryAccess;
    private final Container container;
    private final ResultContainer resultContainer;
    private int maxCraftCount;

    public DIYWorkbenchMenu(int pContainerId, Inventory inventory, BlockPos blockPos, Container container) {
        super((MenuType)TDRegistry.MenuReg.DIY_WORKBENCH.get(), pContainerId);
        this.inventory = inventory;
        this.blockPos = blockPos;
        this.registryAccess = inventory.f_35978_.m_9236_().m_9598_();
        this.container = container;
        this.resultContainer = new ResultContainer();
        DIYWorkbenchMenu.m_38869_((Container)this.container, (int)4);
        for (int i = 0; i < 4; ++i) {
            this.m_38897_(new IngredientSlot(this.container, i, 11 + i * 33, 15, DIYWorkbenchBlockEntity.INGREDIENTS[i]));
        }
        this.m_38897_(new ResultSlot(this.inventory.f_35978_, (Container)this.resultContainer, 0, 155, 15));
        this.addPlayerSlots(11, 134);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getMaxCraftCount() {
        return this.maxCraftCount;
    }

    public RegistryAccess getRegistryAccess() {
        return this.registryAccess;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack copy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack = slot.m_7993_();
            copy = itemstack.m_41777_();
            if (index < this.container.m_6643_() + this.resultContainer.m_6643_()) {
                if (!this.m_38903_(itemstack, this.resultContainer.m_6643_() + this.container.m_6643_(), this.f_38839_.size(), false)) {
                    return ItemStack.f_41583_;
                }
                if (this.maxCraftCount > 0 && index == this.resultContainer.m_6643_() + this.container.m_6643_() - 1) {
                    this.onTakeResult(player, copy, 1);
                    this.m_6199_((Container)this.resultContainer);
                }
            } else if (!this.m_38903_(itemstack, 0, this.container.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return copy;
    }

    public boolean m_6875_(Player pPlayer) {
        return this.container.m_6542_(pPlayer);
    }

    public void m_6199_(Container pContainer) {
        Recipe recipe;
        super.m_6199_(pContainer);
        if (pContainer == this.container) {
            this.updateMaxCraftCount();
            if (this.maxCraftCount <= 0) {
                this.resultContainer.m_6211_();
                this.m_6199_((Container)this.resultContainer);
            }
        }
        if (pContainer == this.resultContainer && this.maxCraftCount > 0 && this.resultContainer.m_7983_() && (recipe = this.resultContainer.m_7928_()) instanceof DIYRecipe) {
            DIYRecipe recipe2 = (DIYRecipe)recipe;
            this.resultContainer.m_6836_(0, recipe2.m_5874_(this.container, this.registryAccess));
            this.m_6199_((Container)this.resultContainer);
        }
    }

    protected void updateMaxCraftCount() {
        this.maxCraftCount = 127;
        if (this.resultContainer.m_7928_() != null) {
            this.maxCraftCount = this.resultContainer.m_7928_().m_8043_(this.registryAccess).m_41741_();
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack item = this.container.m_8020_(i);
            this.maxCraftCount = Math.min(this.maxCraftCount, item.m_41613_());
        }
    }

    public void selectRecipe(Recipe<?> recipe) {
        this.resultContainer.m_6029_(recipe);
        if (this.inventory.f_35978_.m_9236_().m_5776_() && recipe != null) {
            TDNetwork.CHANNEL.sendToServer((Object)new ServerBoundSelectDIYRecipePacket(recipe.m_6423_()));
        }
    }

    public void setRecipe(DIYRecipe recipe) {
        this.resultContainer.m_6029_((Recipe)recipe);
        if (null == recipe) {
            this.resultContainer.m_6211_();
            this.m_6199_((Container)this.resultContainer);
            return;
        }
        this.updateMaxCraftCount();
        if (this.maxCraftCount > 0) {
            this.resultContainer.m_6836_(0, recipe.m_5874_(this.container, this.registryAccess));
        } else {
            this.resultContainer.m_6211_();
        }
        this.m_6199_((Container)this.resultContainer);
    }

    private void onTakeResult(Player player, ItemStack result, int count) {
        for (int i = 0; i < 4; ++i) {
            this.container.m_7407_(i, count);
        }
        result.m_41678_(player.m_9236_(), player, count);
        this.m_6199_(this.container);
        this.m_6199_((Container)this.resultContainer);
        player.m_9236_().m_5594_(player, this.blockPos, SoundEvents.f_12572_, SoundSource.PLAYERS, 1.0f, 0.8f + 0.4f * player.m_217043_().m_188501_());
        player.m_9236_().m_5594_(player, this.blockPos, SoundEvents.f_12574_, SoundSource.PLAYERS, 1.0f, 0.8f + 0.4f * player.m_217043_().m_188501_());
    }

    private void addPlayerSlots(int x, int y) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.inventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)this.inventory, k, x + k * 18, y + 58));
        }
    }

    private class IngredientSlot
    extends Slot {
        private Ingredient ingredient;

        public IngredientSlot(Container pContainer, int pSlot, int pX, int pY, Ingredient ingredient) {
            super(pContainer, pSlot, pX, pY);
            this.ingredient = ingredient;
        }

        public boolean m_5857_(ItemStack pStack) {
            return this.ingredient.test(pStack);
        }

        public void m_6654_() {
            super.m_6654_();
            DIYWorkbenchMenu.this.m_6199_(this.f_40218_);
        }
    }

    private class ResultSlot
    extends Slot {
        private final Player player;

        public ResultSlot(Player player, Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
            this.player = player;
        }

        public boolean m_5857_(ItemStack pStack) {
            return false;
        }

        protected void m_7169_(ItemStack pStack, int pAmount) {
            DIYWorkbenchMenu.this.onTakeResult(this.player, pStack, pAmount);
        }

        protected void m_6405_(int pNumItemsCrafted) {
            DIYWorkbenchMenu.this.onTakeResult(this.player, this.m_7993_(), pNumItemsCrafted);
        }

        public void m_142406_(Player pPlayer, ItemStack pStack) {
            super.m_142406_(pPlayer, pStack);
            DIYWorkbenchMenu.this.onTakeResult(pPlayer, pStack, 1);
        }
    }
}

