/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client.blockentity.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import tanukidecor.block.entity.DisplayBlockEntity;

public class DisplayCaseBER
implements BlockEntityRenderer<DisplayBlockEntity> {
    protected final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    protected final ItemRenderer itemRenderer;
    protected final EntityRenderDispatcher entityRenderDispatcher;
    protected final Font font;

    public DisplayCaseBER(BlockEntityRendererProvider.Context pContext) {
        this.blockEntityRenderDispatcher = pContext.m_173581_();
        this.entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public void render(DisplayBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Level level = pBlockEntity.m_58904_();
        BlockState blockState = pBlockEntity.m_58900_();
        BlockPos blockPos = pBlockEntity.m_58899_();
        ItemStack itemStack = pBlockEntity.m_8020_(0);
        if (itemStack.m_41619_()) {
            return;
        }
        double dx = 0.5;
        double dy = 0.5;
        double dz = 0.5;
        Vector3f translation = new Vector3f(0.5f, 0.5f, 0.5f);
        translation.add((Vector3fc)pBlockEntity.getDisplayTranslation(level, blockState, blockPos, itemStack, 0, pPartialTick));
        Vector3f rotation = pBlockEntity.getDisplayRotation(level, blockState, blockPos, itemStack, 0, pPartialTick);
        Vector3f scale = pBlockEntity.getDisplayScale(level, blockState, blockPos, itemStack, 0, pPartialTick);
        Quaternionf quaternion = Axis.f_252529_.m_252977_(rotation.x());
        quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(rotation.y()));
        quaternion.mul((Quaternionfc)Axis.f_252403_.m_252977_(rotation.z()));
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(dx, dy, dz);
        pPoseStack.m_252781_(quaternion);
        pPoseStack.m_85837_(-dx, -dy, -dz);
        pPoseStack.m_252880_(translation.x(), translation.y(), translation.z());
        pPoseStack.m_85841_(scale.x(), scale.y(), scale.z());
        this.itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIXED, pPackedLight, OverlayTexture.f_118083_, pPoseStack, pBufferSource, level, 0);
        pPoseStack.m_85849_();
        if (pBlockEntity.m_8077_() && this.shouldRenderNameTag(pBlockEntity)) {
            this.renderNameTag(pBlockEntity, pBlockEntity.m_7770_(), pPoseStack, pBufferSource, pPackedLight);
        }
    }

    protected boolean shouldRenderNameTag(BlockEntity blockEntity) {
        Minecraft mc = Minecraft.m_91087_();
        Vec3 pos = Vec3.m_82512_((Vec3i)blockEntity.m_58899_());
        double distance = mc.f_91074_.getBlockReach();
        if (this.entityRenderDispatcher.m_114378_(pos.f_82479_, pos.f_82480_, pos.f_82481_) < distance * distance && mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos = BlockPos.m_274446_((Position)mc.f_91077_.m_82450_());
            BlockState blockState = blockEntity.m_58904_().m_8055_(blockPos);
            return blockPos.equals((Object)blockEntity.m_58899_()) && blockState.m_60713_(blockEntity.m_58900_().m_60734_());
        }
        return false;
    }

    protected void renderNameTag(BlockEntity blockEntity, Component text, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        float height = (float)blockEntity.m_58900_().m_60651_((BlockGetter)blockEntity.m_58904_(), blockEntity.m_58899_(), CollisionContext.m_82749_()).m_83297_(Direction.Axis.Y);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5 + (double)height, 0.5);
        poseStack.m_252781_(this.blockEntityRenderDispatcher.f_112249_.m_253121_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float opacityFactor = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int opacity = (int)(opacityFactor * 255.0f) << 24;
        float x = -this.font.m_92852_((FormattedText)text) / 2;
        this.font.m_272077_(text, x, 0.0f, 0x20FFFFFF, false, matrix4f, multiBufferSource, Font.DisplayMode.SEE_THROUGH, opacity, packedLight);
        this.font.m_272077_(text, x, 0.0f, -1, false, matrix4f, multiBufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.m_85849_();
    }
}

