/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tanukidecor.TDRegistry;
import tanukidecor.block.entity.HourglassBlockEntity;

public class HourglassBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)HourglassBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape[])new VoxelShape[]{HourglassBlock.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), HourglassBlock.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0)});

    public HourglassBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{ACTIVE}).m_61104_(new Property[]{WATERLOGGED});
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof HourglassBlockEntity) {
            HourglassBlockEntity blockEntity2 = (HourglassBlockEntity)blockEntity;
            blockEntity2.startTimer(600);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean waterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)TDRegistry.BlockEntityReg.HOURGLASS.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return HourglassBlockEntity::tick;
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        this.checkPoweredState(pLevel, pPos, pState);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_())) {
            this.checkPoweredState(pLevel, pPos, pState);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof HourglassBlockEntity) {
            HourglassBlockEntity blockEntity2 = (HourglassBlockEntity)blockEntity;
            return blockEntity2.getRedstoneStrength();
        }
        return 0;
    }

    private void checkPoweredState(Level pLevel, BlockPos pPos, BlockState pState) {
        HourglassBlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (!pLevel.m_5776_() && pLevel.m_276867_(pPos) && (blockEntity2 = pLevel.m_7702_(pPos)) instanceof HourglassBlockEntity && !(blockEntity = (HourglassBlockEntity)blockEntity2).isActive() && !((Boolean)pState.m_61143_((Property)ACTIVE)).booleanValue()) {
            blockEntity.startTimer(600);
        }
    }
}

