/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import tanukidecor.TDRegistry;
import tanukidecor.block.RotatingWideBlock;
import tanukidecor.block.entity.DisplayBlockEntity;
import tanukidecor.block.entity.SingleSlotBlockEntity;
import tanukidecor.block.misc.IDisplayProvider;

public class HandcartBlock
extends RotatingWideBlock
implements EntityBlock,
IDisplayProvider {
    public static final VoxelShape SHAPE_EAST = Shapes.m_83124_((VoxelShape)HandcartBlock.m_49796_((double)7.0, (double)12.0, (double)12.0, (double)15.0, (double)14.0, (double)14.0), (VoxelShape[])new VoxelShape[]{HandcartBlock.m_49796_((double)7.0, (double)12.0, (double)2.0, (double)15.0, (double)14.0, (double)4.0), HandcartBlock.m_49796_((double)5.0, (double)0.0, (double)12.0, (double)7.0, (double)6.0, (double)14.0), HandcartBlock.m_49796_((double)5.0, (double)0.0, (double)2.0, (double)7.0, (double)6.0, (double)4.0), Shapes.m_83113_((VoxelShape)HandcartBlock.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)7.0, (double)14.0, (double)14.0), (VoxelShape)HandcartBlock.m_49796_((double)0.0, (double)8.0, (double)4.0, (double)5.0, (double)14.0, (double)12.0), (BooleanOp)BooleanOp.f_82685_)});
    public static final VoxelShape SHAPE_WEST = Shapes.m_83124_((VoxelShape)HandcartBlock.m_49796_((double)4.5, (double)2.0, (double)5.0, (double)6.5, (double)6.0, (double)7.0), (VoxelShape[])new VoxelShape[]{HandcartBlock.m_49796_((double)4.5, (double)2.0, (double)9.0, (double)6.5, (double)6.0, (double)11.0), HandcartBlock.m_49796_((double)3.0, (double)0.0, (double)7.0, (double)8.0, (double)5.0, (double)9.0), Shapes.m_83113_((VoxelShape)HandcartBlock.m_49796_((double)3.0, (double)6.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (VoxelShape)HandcartBlock.m_49796_((double)5.0, (double)8.0, (double)4.0, (double)16.0, (double)14.0, (double)12.0), (BooleanOp)BooleanOp.f_82685_)});
    private static final Vector3f DISPLAY_SCALE = new Vector3f(0.5f, 0.5f, 0.5f);
    private static final RandomSource RANDOM = new LegacyRandomSource(0L);

    public HandcartBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties, RotatingWideBlock.createShapeBuilder(SHAPE_EAST, SHAPE_WEST));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockPos pos = this.getDelegatePos(pState, pPos);
        return SingleSlotBlockEntity.use(pState, pLevel, pos, pPlayer, pHand, pHit);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            SingleSlotBlockEntity.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (this.getDelegatePos(pState, pPos).equals((Object)pPos)) {
            return ((BlockEntityType)TDRegistry.BlockEntityReg.HANDCART.get()).m_155264_(pPos, pState);
        }
        return ((BlockEntityType)TDRegistry.BlockEntityReg.STORAGE_DELEGATE.get()).m_155264_(pPos, pState);
    }

    @Override
    public Vector3f getDisplayRotation(Level level, BlockState blockState, BlockPos blockPos, ItemStack itemStack, int renderPass, float partialTick) {
        DisplayBlockEntity displayBlockEntity;
        RANDOM.m_188584_((long)renderPass * 3311L + blockPos.m_121878_());
        RANDOM.m_188501_();
        BlockEntity blockEntity = level.m_7702_(this.getDelegatePos(blockState, blockPos));
        float biasX = blockEntity instanceof DisplayBlockEntity && !((displayBlockEntity = (DisplayBlockEntity)blockEntity).m_8020_(0).m_41720_() instanceof BlockItem) ? 90.0f : 0.0f;
        float deltaXZ = 15.0f;
        float deltaY = 360.0f;
        return new Vector3f(biasX + RANDOM.m_188501_() * 15.0f * 2.0f - 15.0f, RANDOM.m_188501_() * 360.0f, RANDOM.m_188501_() * 15.0f * 2.0f - 15.0f);
    }

    @Override
    public Vector3f getDisplayTranslation(Level level, BlockState blockState, BlockPos blockPos, ItemStack itemStack, int renderPass, float partialTick) {
        RANDOM.m_188584_((long)renderPass * 1919L + blockPos.m_121878_());
        RANDOM.m_188501_();
        int height = (int)Math.pow(renderPass, 0.425f);
        float dxy = Math.max(0.0625f, (float)height * 0.06125f);
        float deltaX = 0.5f - dxy;
        float deltaY = 0.125f;
        float deltaZ = 0.25f - dxy;
        return new Vector3f(RANDOM.m_188501_() * deltaX * 2.0f - deltaX, (float)height * 0.125f + RANDOM.m_188501_() * 0.125f, RANDOM.m_188501_() * deltaZ * 2.0f - deltaZ);
    }

    @Override
    public Vector3f getDisplayScale(Level level, BlockState blockState, BlockPos blockPos, ItemStack itemStack, int renderPass, float partialTick) {
        return DISPLAY_SCALE;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }
}

