/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.checks;

import com.faboslav.structurify.common.config.data.StructureData;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class JigsawStructureBiomeCheck {
    public static boolean checkBiomes(StructureData structureData, HeightProvider startHeight, Structure.GenerationContext generationContext, HolderSet<Biome> blacklistedBiomes) {
        int biomeCheckDistance = (int)Math.ceil((double)structureData.getBiomeCheckDistance() / 16.0);
        if (biomeCheckDistance == 0 || generationContext.f_226623_() instanceof CheckerboardColumnBiomeSource) {
            return true;
        }
        StructureData.BiomeCheckMode biomeCheckMode = structureData.getBiomeCheckMode();
        if (biomeCheckMode == StructureData.BiomeCheckMode.BLACKLIST && structureData.getBiomeCheckBlacklistedBiomes().isEmpty()) {
            return true;
        }
        ChunkPos chunkPos = generationContext.f_226628_();
        BiomeSource biomeSource = generationContext.f_226623_();
        RandomState randomState = generationContext.f_226624_();
        Climate.Sampler biomeSampler = randomState.m_224579_();
        int blockX = chunkPos.f_45578_ << 4;
        int blockZ = chunkPos.f_45579_ << 4;
        int surfaceY = generationContext.f_226622_().m_223221_(blockX, blockZ, Heightmap.Types.WORLD_SURFACE_WG, generationContext.f_226629_(), generationContext.f_226624_());
        for (int curChunkX = chunkPos.f_45578_ - biomeCheckDistance; curChunkX <= chunkPos.f_45578_ + biomeCheckDistance; ++curChunkX) {
            block5: for (int curChunkZ = chunkPos.f_45579_ - biomeCheckDistance; curChunkZ <= chunkPos.f_45579_ + biomeCheckDistance; ++curChunkZ) {
                blockX = (curChunkX << 4) + 8;
                blockZ = (curChunkZ << 4) + 8;
                Holder biome = biomeSource.m_203407_(QuartPos.m_175400_((int)blockX), QuartPos.m_175400_((int)256), QuartPos.m_175400_((int)blockZ), biomeSampler);
                switch (biomeCheckMode) {
                    case STRICT: {
                        if (generationContext.f_226630_().test(biome)) continue block5;
                        return false;
                    }
                    case BLACKLIST: {
                        if (!blacklistedBiomes.m_203333_(biome)) continue block5;
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

