/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.chakyl.splendidslimes.registry.ModElements;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PlortPressingRecipe
implements Recipe<SimpleContainer> {
    private final Ingredient ingredient;
    private final ItemStack input;
    private final ItemStack output;
    private final ItemStack result;
    private final ResourceLocation id;

    public PlortPressingRecipe(Ingredient ingredient, ItemStack input, ItemStack output, ItemStack result, ResourceLocation id) {
        this.ingredient = ingredient;
        this.input = input;
        this.output = output;
        this.result = result;
        this.id = id;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        boolean outputMatches = true;
        if (this.output != Items.f_41852_.m_7968_() && this.output != null && !this.output.m_41619_()) {
            outputMatches = this.greaterThanOrEquals(this.output, pContainer.m_8020_(1));
        }
        return outputMatches && this.greaterThanOrEquals(this.input, pContainer.m_8020_(0));
    }

    private boolean greaterThanOrEquals(ItemStack self, ItemStack other) {
        if (self.m_41619_()) {
            return other.m_41619_();
        }
        return !other.m_41619_() && self.m_41613_() <= other.m_41613_() && self.m_41720_() == other.m_41720_() && self.areShareTagsEqual(other);
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getInputItem(RegistryAccess pRegistryAccess) {
        return this.input.m_41777_();
    }

    public ItemStack getOutputItem(RegistryAccess pRegistryAccess) {
        if (this.output != null) {
            return this.output.m_41777_();
        }
        return Items.f_41852_.m_7968_();
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModElements.Recipes.PLORT_PRESSING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Type
    implements RecipeType<PlortPressingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "plort_pressing";
    }

    public static class Serializer
    implements RecipeSerializer<PlortPressingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("splendid_slimes", "plort_pressing");

        public PlortPressingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"result"));
            ItemStack outputItem = Items.f_41852_.m_7968_();
            if (pSerializedRecipe.has("output")) {
                outputItem = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            }
            ItemStack inputItem = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"ingredient"));
            Ingredient ingredientItem = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"ingredient"));
            return new PlortPressingRecipe(ingredientItem, inputItem, outputItem, result, pRecipeId);
        }

        @Nullable
        public PlortPressingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient recipeIngredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack input = pBuffer.m_130267_();
            ItemStack output = pBuffer.m_130267_();
            ItemStack result = pBuffer.m_130267_();
            return new PlortPressingRecipe(recipeIngredient, input, output, result, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PlortPressingRecipe pRecipe) {
            pRecipe.ingredient.m_43923_(pBuffer);
            pBuffer.writeItemStack(pRecipe.getInputItem(null), false);
            pBuffer.writeItemStack(pRecipe.getOutputItem(null), false);
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
        }
    }
}

