/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.jade;

import dev.shadowsoffire.placebo.reload.DynamicHolder;
import io.github.chakyl.splendidslimes.SlimyConfig;
import io.github.chakyl.splendidslimes.data.SlimeBreed;
import io.github.chakyl.splendidslimes.entity.SplendidSlime;
import io.github.chakyl.splendidslimes.item.PlortItem;
import io.github.chakyl.splendidslimes.jade.SlimeInfoPlugin;
import io.github.chakyl.splendidslimes.registry.ModElements;
import io.github.chakyl.splendidslimes.util.SlimeData;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.UsernameCache;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public enum SlimeInfoComponentProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, EntityAccessor entityAccessor, IPluginConfig config) {
        boolean isLargo;
        boolean tamed = false;
        boolean bl = isLargo = entityAccessor.getServerData().m_128441_("SecondaryBreed") && !entityAccessor.getServerData().m_128461_("SecondaryBreed").isEmpty();
        if (entityAccessor.getServerData().m_128441_("Breed")) {
            DynamicHolder<SlimeBreed> slime = SlimeData.getSlimeData(entityAccessor.getServerData().m_128461_("Breed"));
            if (slime.isBound()) {
                if (!isLargo) {
                    tooltip.add((Component)Component.m_237110_((String)"entity.splendid_slimes.diet", (Object[])new Object[]{((SlimeBreed)slime.get()).diet()}));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"entity.splendid_slimes.largo_diet", (Object[])new Object[]{((SlimeBreed)slime.get()).diet(), ((SlimeBreed)SlimeData.getSlimeData(entityAccessor.getServerData().m_128461_("SecondaryBreed")).get()).diet()}));
                }
            }
            if (entityAccessor.getServerData().m_128441_("EatingCooldown")) {
                int eatingCooldown = entityAccessor.getServerData().m_128451_("EatingCooldown");
                int maxEatingCooldown = SlimyConfig.slimeStarvingTime;
                int hunger = (int)Math.round((double)eatingCooldown / (double)maxEatingCooldown * 10.0);
                IElementHelper elements = IElementHelper.get();
                ItemStack plort = ((PlortItem)((Object)ModElements.Items.PLORT.get())).m_7968_();
                plort.m_41698_("plort").m_128359_("id", entityAccessor.getServerData().m_128461_("Breed"));
                tooltip.add((Component)Component.m_237115_((String)"entity.splendid_slimes.hunger"));
                for (int i = 0; i < 10; ++i) {
                    if (i >= hunger) {
                        plort = ((PlortItem)((Object)ModElements.Items.PLORT.get())).m_7968_();
                    }
                    tooltip.append(elements.item(plort, 0.5f).size(new Vec2(6.0f, 10.0f)).translate(new Vec2((float)i, -1.0f)));
                }
                tooltip.append(elements.spacer(14, 2));
            }
            if (entityAccessor.getServerData().m_128441_("Tamed")) {
                tamed = entityAccessor.getServerData().m_128471_("Tamed");
            }
            if (tamed && entityAccessor.getServerData().m_128441_("Happiness")) {
                int happiness = entityAccessor.getServerData().m_128451_("Happiness");
                MutableComponent happinessComponent = happiness >= SplendidSlime.HAPPY_THRESHOLD ? Component.m_237115_((String)"entity.splendid_slimes.happy").m_130940_(ChatFormatting.GREEN) : (happiness <= SplendidSlime.FURIOUS_THRESHOLD ? Component.m_237115_((String)"entity.splendid_slimes.furious").m_130940_(ChatFormatting.RED) : (happiness <= SplendidSlime.UNHAPPY_THRESHOLD ? Component.m_237115_((String)"entity.splendid_slimes.sad").m_130940_(ChatFormatting.GOLD) : Component.m_237115_((String)"entity.splendid_slimes.neutral")));
                tooltip.add((Component)happinessComponent);
            } else {
                tooltip.add((Component)Component.m_237115_((String)"entity.splendid_slimes.wild").m_130940_(ChatFormatting.RED));
            }
            if (tamed && entityAccessor.getPlayer().m_6047_()) {
                tooltip.add((Component)Component.m_237110_((String)"entity.splendid_slimes.owner", (Object[])new Object[]{UsernameCache.getLastKnownUsername((UUID)entityAccessor.getServerData().m_128342_("Owner"))}));
            }
        }
    }

    public void appendServerData(CompoundTag data, EntityAccessor accessor) {
        SplendidSlime slime = (SplendidSlime)accessor.getEntity();
        data.m_128359_("Breed", (String)slime.m_20088_().m_135370_(SplendidSlime.BREED));
        data.m_128359_("SecondaryBreed", (String)slime.m_20088_().m_135370_(SplendidSlime.SECONDARY_BREED));
        data.m_128405_("Happiness", ((Integer)slime.m_20088_().m_135370_(SplendidSlime.HAPPINESS)).intValue());
        data.m_128405_("EatingCooldown", ((Integer)slime.m_20088_().m_135370_(SplendidSlime.EATING_COOLDOWN)).intValue());
        data.m_128379_("Tamed", ((Boolean)slime.m_20088_().m_135370_(SplendidSlime.TAMED)).booleanValue());
        if (((SplendidSlime)accessor.getEntity()).getTamed()) {
            data.m_128362_("Owner", Objects.requireNonNull(((Optional)slime.m_20088_().m_135370_(SplendidSlime.OWNER_UUID)).orElse(null)));
        }
    }

    public ResourceLocation getUid() {
        return SlimeInfoPlugin.UID;
    }
}

