/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import io.github.chakyl.splendidslimes.SplendidSlimes;
import io.github.chakyl.splendidslimes.data.SlimeBreed;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;

public class SlimeBreedRegistry
extends DynamicRegistry<SlimeBreed> {
    public static final SlimeBreedRegistry INSTANCE = new SlimeBreedRegistry();
    private Map<String, SlimeBreed> slimesByBreed = new HashMap<String, SlimeBreed>();

    public SlimeBreedRegistry() {
        super(SplendidSlimes.LOGGER, "slimes", true, false);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(new ResourceLocation("splendid_slimes", "slime_breeds"), SlimeBreed.CODEC);
    }

    protected void beginReload() {
        super.beginReload();
        this.slimesByBreed = new HashMap<String, SlimeBreed>();
    }

    protected void onReload() {
        super.onReload();
        this.slimesByBreed = ImmutableMap.copyOf(this.slimesByBreed);
    }

    protected void validateItem(ResourceLocation key, SlimeBreed slimeBreed) {
        slimeBreed.validate(key);
        if (this.slimesByBreed.containsKey(slimeBreed.breed())) {
            String msg = "Attempted to register two slimes (%s and %s) for Entity Type %s!";
            throw new UnsupportedOperationException(String.format(msg, key, this.getKey(this.slimesByBreed.get(slimeBreed.breed())), slimeBreed.breed()));
        }
        this.slimesByBreed.put(slimeBreed.breed(), slimeBreed);
    }

    @Nullable
    public SlimeBreed getForEntity(EntityType<?> type) {
        return this.slimesByBreed.get(type);
    }

    public Map<ResourceLocation, JsonElement> m_5944_(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        return super.m_5944_(pResourceManager, pProfiler);
    }
}

