/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.events;

import com.ninni.species.Species;
import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesStatusEffects;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.entity.mob.update_1.Birt;
import com.ninni.species.server.entity.mob.update_1.BirtEgg;
import com.ninni.species.server.entity.mob.update_1.Deepfish;
import com.ninni.species.server.entity.mob.update_1.Limpet;
import com.ninni.species.server.entity.mob.update_1.Stackatick;
import com.ninni.species.server.entity.mob.update_1.Wraptor;
import com.ninni.species.server.entity.mob.update_2.Cruncher;
import com.ninni.species.server.entity.mob.update_2.Goober;
import com.ninni.species.server.entity.mob.update_2.Mammutilation;
import com.ninni.species.server.entity.mob.update_2.Springling;
import com.ninni.species.server.entity.mob.update_2.Treeper;
import com.ninni.species.server.entity.mob.update_2.Trooper;
import com.ninni.species.server.entity.mob.update_3.Bewereager;
import com.ninni.species.server.entity.mob.update_3.CliffHanger;
import com.ninni.species.server.entity.mob.update_3.DeflectorDummy;
import com.ninni.species.server.entity.mob.update_3.Ghoul;
import com.ninni.species.server.entity.mob.update_3.LeafHanger;
import com.ninni.species.server.entity.mob.update_3.Quake;
import com.ninni.species.server.entity.mob.update_3.Spectre;
import com.ninni.species.server.entity.mob.update_3.Wicked;
import com.ninni.species.server.item.MobHeadItem;
import com.ninni.species.server.item.SpectraliburItem;
import com.ninni.species.server.item.WickedMaskItem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="species", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEvents {
    DispenseItemBehavior dispenseBucket = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource p_123561_, ItemStack p_123562_) {
            DispensibleContainerItem dispensiblecontaineritem = (DispensibleContainerItem)p_123562_.m_41720_();
            BlockPos blockpos = p_123561_.m_7961_().m_121945_((Direction)p_123561_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel level = p_123561_.m_7727_();
            if (dispensiblecontaineritem.emptyContents(null, (Level)level, blockpos, null, p_123562_)) {
                dispensiblecontaineritem.m_142131_(null, (Level)level, p_123562_, blockpos);
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            return this.defaultDispenseItemBehavior.m_6115_(p_123561_, p_123562_);
        }
    };

    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)SpeciesEntities.WRAPTOR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Wraptor::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.DEEPFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Deepfish::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.STACKATICK.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE_WG, Stackatick::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.BIRT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE_WG, Birt::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.LIMPET.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Limpet::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.TREEPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Treeper::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.GOOBER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE_WG, Goober::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.CRUNCHER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE_WG, Cruncher::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.MAMMUTILATION.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE, Mammutilation::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.SPRINGLING.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE, Springling::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.GHOUL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Ghoul::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.QUAKE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.WICKED.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Wicked::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.BEWEREAGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Bewereager::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.CLIFF_HANGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CliffHanger::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)SpeciesEntities.LEAF_HANGER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LeafHanger::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
    }

    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SpeciesEntities.WRAPTOR.get(), Wraptor.createWraptorAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.DEEPFISH.get(), Deepfish.createDeepfishAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.STACKATICK.get(), Stackatick.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.BIRT.get(), Birt.createBirtAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.LIMPET.get(), Limpet.createLimpetAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.TREEPER.get(), Treeper.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.TROOPER.get(), Trooper.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.GOOBER.get(), Goober.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.CRUNCHER.get(), Cruncher.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.MAMMUTILATION.get(), Mammutilation.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.SPRINGLING.get(), Springling.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.GHOUL.get(), Ghoul.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.QUAKE.get(), Quake.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.DEFLECTOR_DUMMY.get(), DeflectorDummy.m_21183_().m_22265_());
        event.put((EntityType)SpeciesEntities.SPECTRE.get(), Spectre.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.WICKED.get(), Wicked.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.BEWEREAGER.get(), Bewereager.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.LEAF_HANGER.get(), LeafHanger.createAttributes().m_22265_());
        event.put((EntityType)SpeciesEntities.CLIFF_HANGER.get(), CliffHanger.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public void onVillagerTraderInit(VillagerTradesEvent event) {
        VillagerProfession type = event.getType();
        Int2ObjectMap trades = event.getTrades();
        if (type == VillagerProfession.f_35589_) {
            ((List)trades.get(4)).add(new BasicItemListing(new ItemStack((ItemLike)SpeciesItems.GHOUL_TONGUE.get()), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42616_, 3), 12, 8, 0.2f));
        }
    }

    @SubscribeEvent
    public void onShieldBlock(ShieldBlockEvent event) {
        LivingEntity livingEntity = event.getEntity();
        DamageSource damageSource = event.getDamageSource();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (damageSource.m_7639_() instanceof Cruncher || damageSource.m_7639_() instanceof Quake && event.getBlockedDamage() > 40.0f) {
                player.m_36384_(true);
            }
        }
        CompoundTag tag = event.getEntity().m_21211_().m_41784_();
        if (event.getEntity().m_21211_().m_150930_((Item)SpeciesItems.RICOSHIELD.get())) {
            if (tag.m_128441_("StoredDamage")) {
                tag.m_128350_("StoredDamage", Math.min(tag.m_128457_("StoredDamage") + event.getBlockedDamage(), 40.0f));
            } else {
                tag.m_128350_("StoredDamage", Math.min(event.getBlockedDamage(), 40.0f));
            }
            event.getEntity().m_9236_().m_5594_(null, event.getEntity().m_20183_(), (SoundEvent)SpeciesSoundEvents.RICOSHIELD_ABSORB.get(), SoundSource.PLAYERS, 1.0f, tag.m_128457_("StoredDamage") * 0.05f);
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        Level level = livingEntity.m_9236_();
        if (!level.f_46443_ && livingEntity.m_21023_((MobEffect)SpeciesStatusEffects.BLOODLUST.get())) {
            BlockPos blockpos = BlockPos.m_274561_((double)livingEntity.m_20185_(), (double)livingEntity.m_20188_(), (double)livingEntity.m_20189_());
            float f = livingEntity.m_213856_();
            if (f > 0.5f && level.f_46441_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f && !livingEntity.m_20072_() && level.m_45527_(blockpos) && level.m_46461_()) {
                level.m_6269_(null, (Entity)livingEntity, (SoundEvent)SpeciesSoundEvents.BLOODLUST_REMOVED.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                livingEntity.m_21195_((MobEffect)SpeciesStatusEffects.BLOODLUST.get());
            }
        }
    }

    @SubscribeEvent
    public void onMobEventApplied(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        MobEffectInstance mobEffectInstance = event.getEffectInstance();
        if (livingEntity.m_21023_((MobEffect)SpeciesStatusEffects.WITHER_RESISTANCE.get()) && mobEffectInstance.m_19544_() == MobEffects.f_19615_) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Player player;
        LivingEntity attacked = event.getEntity();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_21023_((MobEffect)SpeciesStatusEffects.BLOODLUST.get()) && amount > attacked.m_21223_()) {
            attacked.m_9236_().m_6263_(null, attacked.m_20185_(), attacked.m_20186_(), attacked.m_20189_(), (SoundEvent)SpeciesSoundEvents.BLOODLUST_FEED.get(), attacked.m_5720_(), 1.0f, 1.0f);
            player.m_36324_().m_38707_((int)(attacked.m_21233_() / 5.0f), attacked.m_21233_() / 5.0f * 0.1f);
        }
        if (attacked.m_21023_((MobEffect)SpeciesStatusEffects.COMBUSTION.get()) && amount > attacked.m_21223_()) {
            int amplifier = attacked.m_21124_((MobEffect)SpeciesStatusEffects.COMBUSTION.get()).m_19564_();
            attacked.m_9236_().m_254849_((Entity)attacked, attacked.m_20185_(), attacked.m_20227_(0.0625), attacked.m_20189_(), (float)amplifier, Level.ExplosionInteraction.MOB);
            attacked.m_9236_().m_6443_(LivingEntity.class, attacked.m_20191_().m_82400_(2.0), livingEntity -> livingEntity.m_6084_() && !livingEntity.m_7306_((Entity)attacked)).forEach(livingEntity -> livingEntity.m_6469_(attacked.m_9236_().m_269111_().m_269333_(attacked), 6.0f));
            attacked.m_21195_((MobEffect)SpeciesStatusEffects.COMBUSTION.get());
        }
        if ((entity = source.m_7639_()) instanceof Player && (player = (Player)entity).m_21205_().m_41720_() instanceof SpectraliburItem && !attacked.m_6095_().m_204039_(SpeciesTags.SOULLESS) && amount > attacked.m_21223_() && (!player.m_21205_().m_41784_().m_128441_("Souls") || player.m_21205_().m_41784_().m_128451_("Souls") != 5)) {
            CompoundTag tag = player.m_21205_().m_41783_().m_6426_();
            tag.m_128405_("Souls", Math.min(player.m_21205_().m_41783_().m_128451_("Souls") + 1, 5));
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_6263_(null, attacked.m_20185_(), attacked.m_20186_(), attacked.m_20189_(), (SoundEvent)SpeciesSoundEvents.SPECTRALIBUR_COLLECT_SOUL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.COLLECTED_SOUL.get()), attacked.m_20185_(), attacked.m_20186_() + (double)0.2f, attacked.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            player.m_21205_().m_41751_(tag);
        }
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpeciesItems.BIRT_EGG.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level world, Position position, ItemStack stack) {
                return (Projectile)Util.m_137469_((Object)((Object)new BirtEgg(world, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stack));
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpeciesItems.DEFLECTOR_DUMMY.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            public ItemStack m_7498_(BlockSource blockSource, ItemStack stack) {
                Direction direction = (Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos blockpos = blockSource.m_7961_().m_121945_(direction);
                ServerLevel serverlevel = blockSource.m_7727_();
                Consumer consumer = EntityType.m_264081_(p_277236_ -> p_277236_.m_146922_(direction.m_122435_()), (ServerLevel)serverlevel, (ItemStack)stack, null);
                DeflectorDummy dummy = (DeflectorDummy)((EntityType)SpeciesEntities.DEFLECTOR_DUMMY.get()).m_262455_(serverlevel, stack.m_41783_(), consumer, blockpos, MobSpawnType.DISPENSER, false, false);
                if (dummy != null) {
                    stack.m_41774_(1);
                }
                return stack;
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpeciesItems.WICKED_MASK.get()), (DispenseItemBehavior)WickedMaskItem.DISPENSE_ITEM_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpeciesItems.WICKED_CANDLE.get()), (DispenseItemBehavior)MobHeadItem.DISPENSE_ITEM_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpeciesItems.QUAKE_HEAD.get()), (DispenseItemBehavior)MobHeadItem.DISPENSE_ITEM_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpeciesItems.GHOUL_HEAD.get()), (DispenseItemBehavior)MobHeadItem.DISPENSE_ITEM_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpeciesItems.BEWEREAGER_HEAD.get()), (DispenseItemBehavior)MobHeadItem.DISPENSE_ITEM_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpeciesItems.DEEPFISH_BUCKET.get()), (DispenseItemBehavior)this.dispenseBucket);
    }

    @SubscribeEvent
    public void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)Species.PROXY.getLimpetOreManager());
        event.addListener((PreparableReloadListener)Species.PROXY.getGooberGooManager());
        event.addListener((PreparableReloadListener)Species.PROXY.getCruncherPelletManager());
    }
}

