/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_2;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.ninni.species.client.inventory.CruncherInventoryMenu;
import com.ninni.species.registry.SpeciesDamageTypes;
import com.ninni.species.registry.SpeciesEntityDataSerializers;
import com.ninni.species.registry.SpeciesNetwork;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.data.CruncherPelletManager;
import com.ninni.species.server.entity.ai.CruncherAi;
import com.ninni.species.server.packet.OpenCruncherScreenPacket;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Cruncher
extends Animal
implements InventoryCarrier,
HasCustomInventoryScreen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<CruncherState> CRUNCHER_STATE = SynchedEntityData.m_135353_(Cruncher.class, (EntityDataSerializer)((EntityDataSerializer)SpeciesEntityDataSerializers.CRUNCHER_STATE.get()));
    private static final EntityDataAccessor<Integer> STUNNED_TICKS = SynchedEntityData.m_135353_(Cruncher.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState roarAnimationState = new AnimationState();
    public final AnimationState spitAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState stunAnimationState = new AnimationState();
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent((Component)Component.m_237110_((String)"bar.species.cruncher", (Object[])new Object[]{this.m_5446_().getString()}), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_6).m_7003_(true).m_7005_(true);
    private final int maxHunger = 3;
    @Nullable
    private CruncherPelletManager.CruncherPelletData pelletData = null;
    private int hunger;
    private int idleAnimationTimeout = 0;
    private int spits;
    private long day = -1L;
    public final SimpleContainer inventory = new SimpleContainer(1);

    public Cruncher(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22281_, 10.0);
    }

    protected Brain.Provider<Cruncher> m_5490_() {
        return Brain.m_21923_(CruncherAi.MEMORY_TYPES, CruncherAi.SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return CruncherAi.makeBrain((Brain<Cruncher>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<Cruncher> m_6274_() {
        return super.m_6274_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            if (this.getHunger() > 0) {
                if (this.m_21439_(BlockPathTypes.LEAVES) != 0.0f) {
                    this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
                }
                if (this.bossEvent.m_18862_() != this.getBarColor()) {
                    this.bossEvent.m_6451_(this.getBarColor());
                }
                if (this.f_19862_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                    boolean bl = false;
                    AABB aABB = this.m_20191_().m_82400_(0.2);
                    Iterator var8 = BlockPos.m_121976_((int)Mth.m_14107_((double)aABB.f_82288_), (int)Mth.m_14107_((double)aABB.f_82289_), (int)Mth.m_14107_((double)aABB.f_82290_), (int)Mth.m_14107_((double)aABB.f_82291_), (int)Mth.m_14107_((double)aABB.f_82292_), (int)Mth.m_14107_((double)aABB.f_82293_)).iterator();
                    while (true) {
                        if (!var8.hasNext()) {
                            if (!bl && this.m_20096_()) {
                                this.m_6135_();
                            }
                            break;
                        }
                        BlockPos blockPos = (BlockPos)var8.next();
                        BlockState blockState = this.m_9236_().m_8055_(blockPos);
                        Block block = blockState.m_60734_();
                        if (!(block instanceof LeavesBlock)) continue;
                        bl = this.m_9236_().m_46953_(blockPos, true, (Entity)this) || bl;
                    }
                }
            } else if (this.m_21439_(BlockPathTypes.LEAVES) == 0.0f) {
                this.m_21441_(BlockPathTypes.LEAVES, -1.0f);
            }
        }
    }

    protected void m_8024_() {
        boolean flag;
        this.m_9236_().m_46473_().m_6180_("cruncherBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("cruncherActivityUpdate");
        CruncherAi.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
        boolean bl = flag = this.getHunger() <= 0;
        if (flag && !this.bossEvent.m_8324_().isEmpty()) {
            this.bossEvent.m_7706_();
            this.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        }
        if (flag) {
            return;
        }
        float f = this.getHunger();
        Objects.requireNonNull(this);
        this.bossEvent.m_142711_(f / 3.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CRUNCHER_STATE, (Object)CruncherState.IDLE);
        this.f_19804_.m_135372_(STUNNED_TICKS, (Object)0);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_((Component)Component.m_237110_((String)"bar.species.cruncher", (Object[])new Object[]{this.m_5446_().getString()}));
        }
        this.bossEvent.m_6451_(this.getBarColor());
        if (compoundTag.m_128425_("PelletData", 10)) {
            CruncherPelletManager.CruncherPelletData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128469_("PelletData"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setPelletData);
        }
        if (compoundTag.m_128425_("PelletFuel", 10)) {
            this.inventory.m_6836_(0, ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("PelletFuel")));
        }
        this.setHunger(compoundTag.m_128451_("Hunger"));
        this.setSpits(compoundTag.m_128451_("Spit"));
        this.setStunnedTicks(compoundTag.m_128451_("StunnedTicks"));
        this.setDay(compoundTag.m_128454_("Day"));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.bossEvent.m_6456_((Component)Component.m_237110_((String)"bar.species.cruncher", (Object[])new Object[]{this.m_5446_().getString()}));
        this.bossEvent.m_6451_(this.getBarColor());
        if (this.pelletData != null) {
            CruncherPelletManager.CruncherPelletData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.getPelletData()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.m_128365_("PelletData", tag));
        }
        if (!this.inventory.m_8020_(0).m_41619_()) {
            compoundTag.m_128365_("PelletFuel", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        compoundTag.m_128405_("Hunger", this.getHunger());
        compoundTag.m_128405_("Spit", this.getSpits());
        compoundTag.m_128405_("StunnedTicks", this.getStunnedTicks());
        compoundTag.m_128356_("Day", this.getDay());
    }

    public BossEvent.BossBarColor getBarColor() {
        return switch (this.getHunger()) {
            case 3 -> BossEvent.BossBarColor.BLUE;
            case 2 -> BossEvent.BossBarColor.PURPLE;
            case 1 -> BossEvent.BossBarColor.RED;
            default -> BossEvent.BossBarColor.BLUE;
        };
    }

    @Nullable
    public CruncherPelletManager.CruncherPelletData getPelletData() {
        return this.pelletData;
    }

    public void setPelletData(CruncherPelletManager.CruncherPelletData data) {
        this.pelletData = data;
    }

    public long getDay() {
        return this.day;
    }

    public void setDay(long day) {
        this.day = day;
    }

    public DamageSource crunch(LivingEntity livingEntity) {
        return this.m_269291_().m_269298_(SpeciesDamageTypes.CRUNCH, (Entity)livingEntity);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (this.getHunger() > 0) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (this.getHunger() == 0 && !this.m_9236_().f_46443_) {
            this.m_213583_(player);
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_204117_(SpeciesTags.CRUNCHER_EATS) && this.getStunnedTicks() > 0) {
            itemStack.m_41774_(1);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SpeciesCriterion.FEED_CRUNCHER.trigger(serverPlayer);
            }
            this.setHunger(this.getHunger() - 1);
            this.bossEvent.m_6451_(this.getBarColor());
            if (this.getHunger() == 0) {
                this.bossEvent.m_142711_(0.0f);
                this.bossEvent.m_8321_(false);
                this.m_6274_().m_21936_(MemoryModuleType.f_26372_);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            }
            this.transitionTo(CruncherState.IDLE);
            this.m_5496_(SoundEvents.f_11912_, 2.0f, 1.0f);
            this.m_21153_(this.m_21233_());
            this.setStunnedTicks(0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void m_5907_() {
        super.m_5907_();
        this.inventory.m_19195_().forEach(arg_0 -> ((Cruncher)this).m_19983_(arg_0));
        ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemStack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemStack)) {
            this.m_19983_(itemStack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_36096_ != serverPlayer.f_36095_) {
                serverPlayer.m_6915_();
            }
            serverPlayer.m_9217_();
            SpeciesNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new OpenCruncherScreenPacket(this.m_19879_(), this.inventory.m_6643_(), serverPlayer.f_8940_));
            serverPlayer.f_36096_ = new CruncherInventoryMenu(serverPlayer.f_8940_, serverPlayer.m_150109_(), (Container)this.inventory, this);
            serverPlayer.m_143399_(serverPlayer.f_36096_);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)serverPlayer, serverPlayer.f_36096_));
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (this.getState() == CruncherState.ROAR) {
            f = (f - 1.0f) / 2.0f;
        }
        return super.m_6469_(damageSource, f);
    }

    protected void m_6475_(DamageSource damageSource, float f) {
        boolean flag = (double)(this.m_21223_() / this.m_21233_()) <= 0.75;
        Entity entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)livingEntity);
        }
        if (this.getHunger() > 0 && flag && this.getState() != CruncherState.STUNNED) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.CRUNCHER_STUN.get(), 2.0f, 1.0f);
            this.transitionTo(CruncherState.STUNNED);
            this.setStunnedTicks(320);
        }
        super.m_6475_(damageSource, f);
    }

    public void m_8119_() {
        super.m_8119_();
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double headX = 2.0f * this.m_6134_() * Mth.m_14031_((float)((float)Math.PI + angle));
        double headZ = 2.0f * this.m_6134_() * Mth.m_14089_((float)angle);
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        } else {
            Level level;
            if (this.getState() == CruncherState.STUNNED) {
                int ticks;
                level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel world = (ServerLevel)level;
                    if (this.f_19797_ % 6 == 1) {
                        world.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.FOOD.get()), this.m_20185_() + headX, this.m_20188_() + 1.5, this.m_20189_() + headZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                if ((ticks = this.getStunnedTicks()) > 0) {
                    this.setStunnedTicks(ticks - 1);
                    this.m_5634_(1.0f);
                } else {
                    this.transitionTo(CruncherState.IDLE);
                }
            }
            if (this.getHunger() > 0 && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                if (this.f_19796_.m_188501_() < 0.1f) {
                    world.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.FALLING_PELLET_DRIP.get()), this.m_20208_(0.4) + headX, this.m_20188_(), this.m_20262_(0.4) + headZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public int getHunger() {
        return this.hunger;
    }

    public void setHunger(int hunger) {
        this.hunger = hunger;
    }

    public int getSpits() {
        return this.spits;
    }

    public void setSpits(int spits) {
        this.spits = spits;
    }

    private void setupAnimationStates() {
        switch (this.getState()) {
            case IDLE: {
                if (this.idleAnimationTimeout <= 0) {
                    this.idleAnimationTimeout = 80;
                    this.idleAnimationState.m_216977_(this.f_19797_);
                } else {
                    --this.idleAnimationTimeout;
                }
                this.roarAnimationState.m_216973_();
                this.attackAnimationState.m_216973_();
                this.stunAnimationState.m_216973_();
                break;
            }
            case ROAR: {
                this.stunAnimationState.m_216973_();
                this.attackAnimationState.m_216973_();
                this.spitAnimationState.m_216973_();
                this.roarAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case STOMP: {
                this.stunAnimationState.m_216973_();
                this.roarAnimationState.m_216973_();
                this.spitAnimationState.m_216973_();
                this.attackAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case STUNNED: {
                this.stunAnimationState.m_216982_(this.f_19797_);
            }
        }
    }

    public void m_7822_(byte b) {
        if (b == 4) {
            this.spitAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(b);
        }
    }

    public boolean canAttack() {
        CruncherState state = this.getState();
        return this.getHunger() > 0 && state == CruncherState.IDLE;
    }

    public boolean isTargetClose() {
        LivingEntity entity = (LivingEntity)this.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        if (entity.m_213877_()) {
            this.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return player.f_8941_.m_9294_() && player.m_20270_((Entity)this) <= 9.0f;
        }
        return entity.m_20270_((Entity)this) <= 9.0f;
    }

    public Optional<LivingEntity> getHurtBy() {
        if (this.getHunger() == 0) {
            return Optional.empty();
        }
        return this.m_6274_().m_21952_(MemoryModuleType.f_26381_).map(DamageSource::m_7639_).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast);
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.CRUNCHER_STEP.get(), 1.0f, this.m_6100_());
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.getState() == CruncherState.IDLE ? (SoundEvent)SpeciesSoundEvents.CRUNCHER_IDLE.get() : SoundEvents.f_271165_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SpeciesSoundEvents.CRUNCHER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.CRUNCHER_DEATH.get();
    }

    public void transitionTo(CruncherState cruncherState) {
        switch (cruncherState) {
            case IDLE: {
                this.setState(CruncherState.IDLE);
                break;
            }
            case ROAR: {
                this.setState(CruncherState.ROAR);
                break;
            }
            case STOMP: {
                this.setState(CruncherState.STOMP);
                break;
            }
            case STUNNED: {
                this.setState(CruncherState.STUNNED);
            }
        }
    }

    public CruncherState getState() {
        return (CruncherState)((Object)this.f_19804_.m_135370_(CRUNCHER_STATE));
    }

    public void setState(CruncherState cruncherState) {
        this.f_19804_.m_135381_(CRUNCHER_STATE, (Object)cruncherState);
    }

    public int getStunnedTicks() {
        return (Integer)this.f_19804_.m_135370_(STUNNED_TICKS);
    }

    public void setStunnedTicks(int stunnedTicks) {
        this.f_19804_.m_135381_(STUNNED_TICKS, (Object)stunnedTicks);
    }

    public boolean cannotWalk() {
        CruncherState state = this.getState();
        return state != CruncherState.IDLE;
    }

    public boolean hasInventoryChanged(Container container) {
        return this.inventory != container;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public static boolean canSpawn(EntityType<Cruncher> entity, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Monster.m_217057_(entity, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setHunger(3);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public static enum CruncherState implements StringRepresentable
    {
        IDLE("idle", SoundEvents.f_271165_, 0),
        ROAR("roar", SoundEvents.f_271165_, 80),
        STOMP("stomp", SoundEvents.f_271165_, 20),
        STUNNED("stunned", SoundEvents.f_271165_, 0);

        private final String name;
        private final SoundEvent soundEvent;
        private final int duration;

        private CruncherState(String name, SoundEvent soundEvents, int duration) {
            this.name = name;
            this.soundEvent = soundEvents;
            this.duration = duration;
        }

        public String m_7912_() {
            return this.name;
        }

        public SoundEvent getSoundEvent() {
            return this.soundEvent;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

