/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.ai.tasks;

import com.google.common.collect.ImmutableMap;
import com.ninni.species.Species;
import com.ninni.species.client.screen.ScreenShakeEvent;
import com.ninni.species.registry.SpeciesDamageTypes;
import com.ninni.species.registry.SpeciesMemoryModuleTypes;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.entity.mob.update_2.Cruncher;
import java.util.Map;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public class StompAttack
extends Behavior<Cruncher> {
    private static final Cruncher.CruncherState cruncherState = Cruncher.CruncherState.STOMP;

    public StompAttack() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)SpeciesMemoryModuleTypes.STOMP_CHARGING.get()), (Object)MemoryStatus.VALUE_ABSENT), cruncherState.getDuration());
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Cruncher livingEntity) {
        return livingEntity.canAttack() && livingEntity.isTargetClose();
    }

    protected boolean canStillUse(ServerLevel serverLevel, Cruncher livingEntity, long l) {
        return true;
    }

    protected void start(ServerLevel serverLevel, Cruncher livingEntity, long l) {
        if (livingEntity.getState() == Cruncher.CruncherState.IDLE) {
            livingEntity.transitionTo(cruncherState);
        }
        livingEntity.m_5496_((SoundEvent)SpeciesSoundEvents.CRUNCHER_STOMP.get(), 2.0f, 1.0f);
        livingEntity.m_6274_().m_21882_((MemoryModuleType)SpeciesMemoryModuleTypes.STOMP_CHARGING.get(), (Object)Unit.INSTANCE, 14L);
    }

    protected void tick(ServerLevel serverLevel, Cruncher cruncher, long l) {
        int i;
        Brain<Cruncher> brain = cruncher.m_6274_();
        LivingEntity target = brain.m_21952_(MemoryModuleType.f_26372_).orElse(null);
        if (target == null) {
            return;
        }
        cruncher.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
        brain.m_21936_(MemoryModuleType.f_26370_);
        if (brain.m_21952_((MemoryModuleType)SpeciesMemoryModuleTypes.STOMP_CHARGING.get()).isPresent()) {
            return;
        }
        for (LivingEntity entity : serverLevel.m_45976_(LivingEntity.class, cruncher.m_20191_().m_82400_(6.0))) {
            boolean reachable;
            boolean bl = reachable = entity.m_20186_() > cruncher.m_20186_() && entity.m_20270_((Entity)cruncher) > 6.0f;
            boolean self = entity instanceof Cruncher;
            if (self || reachable) continue;
            float damage = 8.0f / (0.15f * entity.m_20270_((Entity)cruncher));
            Vec3 vec3 = cruncher.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
            Vec3 vec32 = entity.m_146892_().m_82546_(vec3);
            Vec3 vec33 = vec32.m_82541_();
            entity.m_6469_(serverLevel.m_269111_().m_269298_(SpeciesDamageTypes.CRUNCH, (Entity)cruncher), damage);
            double d = 0.35 * (1.0 - entity.m_21133_(Attributes.f_22278_));
            double e = 2.0 * (1.0 - entity.m_21133_(Attributes.f_22278_));
            entity.m_5997_(vec33.m_7096_() * e, vec33.m_7098_() * d, vec33.m_7094_() * e);
        }
        Species.PROXY.screenShake(new ScreenShakeEvent(cruncher.m_20182_(), 10, 2.5f, 25.0f, false));
        for (i = 0; i <= cruncher.m_217043_().m_188503_(50) + 80; ++i) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, cruncher.m_20208_(2.0), cruncher.m_20186_() + 0.25, cruncher.m_20262_(2.0), 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (i = 0; i <= cruncher.m_217043_().m_188503_(20) + 20; ++i) {
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.ASCENDING_DUST.get()), cruncher.m_20208_(2.0), cruncher.m_20186_() + 0.25, cruncher.m_20262_(2.0), 1, 0.0, 1.0, 0.0, 0.0);
        }
        cruncher.m_6274_().m_21882_((MemoryModuleType)SpeciesMemoryModuleTypes.STOMP_CHARGING.get(), (Object)Unit.INSTANCE, 42L);
    }

    protected void stop(ServerLevel serverLevel, Cruncher livingEntity, long l) {
        if (livingEntity.getState() == cruncherState) {
            livingEntity.transitionTo(Cruncher.CruncherState.IDLE);
        }
    }
}

