/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.data;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ninni.species.Species;
import com.ninni.species.server.entity.mob.update_1.Limpet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LimpetOreManager
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_INSTANCE = new GsonBuilder().create();
    public static final List<LimpetOreData> DATA = Lists.newArrayList();
    public static final String DEFAULT_VARIANT_NAME = "species:shell";

    public LimpetOreManager() {
        super(GSON_INSTANCE, "gameplay/limpet_ores");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        DATA.clear();
        object.forEach((resourceLocation, jsonElement) -> {
            LimpetOreData data = LimpetOreData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).result().orElseGet(() -> {
                Species.LOGGER.error("Failed to read Limpet ore entry for resource {}", resourceLocation);
                return null;
            });
            if (data != null) {
                DATA.add(data);
            }
        });
        Species.LOGGER.info("Loaded {} Limpet ore entries", (Object)DATA.size());
    }

    public static void setOre(Limpet limpet) {
        WeightedEntry variant;
        int minYLevel;
        int maxYLevel;
        int yLevel;
        Holder holder = limpet.m_9236_().m_204166_(limpet.m_20183_());
        List<WeightedEntry> weightedEntries = LimpetOreManager.buildWeightedEntries(arg_0 -> LimpetOreManager.lambda$setOre$2(holder, yLevel = limpet.m_20183_().m_123342_(), maxYLevel = limpet.m_9236_().m_151558_(), minYLevel = limpet.m_9236_().m_141937_(), arg_0));
        if (weightedEntries.isEmpty()) {
            weightedEntries = LimpetOreManager.buildWeightedEntries(data -> data.location().isEmpty() && yLevel <= data.maxSpawnHeight().orElse(maxYLevel) && yLevel > data.minSpawnHeight().orElse(minYLevel));
        }
        if ((variant = LimpetOreManager.chooseWeightedVariant(weightedEntries, limpet)) != null) {
            limpet.setOre(variant.id().toString());
            limpet.setMaxCount(variant.maxCount());
            limpet.setOreItemStack(variant.stack());
            limpet.setOreBlockState(variant.state());
        } else {
            LimpetOreManager.setNoOre(limpet);
        }
    }

    public static void setNoOre(Limpet limpet) {
        limpet.setOre(DEFAULT_VARIANT_NAME);
        limpet.setMaxCount(0);
        limpet.setOreItemStack(Items.f_42499_.m_7968_());
        limpet.setOreBlockState(Blocks.f_50069_.m_49966_());
    }

    private static WeightedEntry chooseWeightedVariant(List<WeightedEntry> entries, Limpet limpet) {
        if (entries.isEmpty()) {
            return null;
        }
        int totalWeight = entries.stream().mapToInt(WeightedEntry::weight).sum();
        int randomWeight = limpet.m_9236_().f_46441_.m_188503_(totalWeight);
        if (totalWeight <= 0) {
            return null;
        }
        int cumulativeWeight = 0;
        for (WeightedEntry entry : entries) {
            if (randomWeight >= (cumulativeWeight += entry.weight())) continue;
            return entry;
        }
        return null;
    }

    private static List<WeightedEntry> buildWeightedEntries(Predicate<LimpetOreData> filter) {
        ArrayList<WeightedEntry> weightedEntries = new ArrayList<WeightedEntry>();
        for (LimpetOreData data : DATA) {
            if (data.item == Items.f_41852_ || data.block == Blocks.f_50016_ || !filter.test(data) || !data.spawnWeight().isPresent() || data.spawnWeight().get() <= 0) continue;
            ItemStack itemStack = data.item() != null ? data.item().m_7968_() : Items.f_42499_.m_7968_();
            weightedEntries.add(new WeightedEntry(data.id(), data.spawnWeight().get(), data.maxCount().orElse(0), itemStack, data.block().m_49966_()));
        }
        return weightedEntries;
    }

    private static /* synthetic */ boolean lambda$setOre$2(Holder holder, int yLevel, int maxYLevel, int minYLevel, LimpetOreData data) {
        return data.location().isPresent() && data.location().get().matchesBiome((Holder<Biome>)holder) && yLevel <= data.maxSpawnHeight().orElse(maxYLevel) && yLevel > data.minSpawnHeight().orElse(minYLevel);
    }

    public record WeightedEntry(ResourceLocation id, int weight, int maxCount, ItemStack stack, BlockState state) {
    }

    public record LimpetOreData(ResourceLocation id, Item item, Block block, Optional<Integer> maxCount, Optional<Location> location, Optional<Integer> spawnWeight, Optional<Integer> maxSpawnHeight, Optional<Integer> minSpawnHeight) {
        public static final Codec<Location> LOCATION_CODEC = Codec.either((Codec)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_), (Codec)TagKey.m_203886_((ResourceKey)Registries.f_256952_)).xmap(Location::new, Location::get);
        public static final Codec<LimpetOreData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(LimpetOreData::id), (App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(LimpetOreData::item), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("block").forGetter(LimpetOreData::block), (App)Codec.INT.optionalFieldOf("maxCount").forGetter(LimpetOreData::maxCount), (App)LOCATION_CODEC.optionalFieldOf("location").forGetter(LimpetOreData::location), (App)Codec.INT.optionalFieldOf("spawnWeight").forGetter(LimpetOreData::spawnWeight), (App)Codec.INT.optionalFieldOf("maxSpawnHeight").forGetter(LimpetOreData::maxSpawnHeight), (App)Codec.INT.optionalFieldOf("minSpawnHeight").forGetter(LimpetOreData::minSpawnHeight)).apply((Applicative)instance, LimpetOreData::new));
    }

    public static class Location {
        private final Either<ResourceKey<Biome>, TagKey<Biome>> value;

        public Location(Either<ResourceKey<Biome>, TagKey<Biome>> value) {
            this.value = value;
        }

        public Either<ResourceKey<Biome>, TagKey<Biome>> get() {
            return this.value;
        }

        public boolean matchesBiome(Holder<Biome> biome) {
            if (this.value.left().isPresent()) {
                return biome.m_203565_((ResourceKey)this.value.left().get());
            }
            return biome.m_203656_((TagKey)this.value.right().get());
        }
    }
}

