/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ninni.species.Species;
import com.ninni.species.registry.SpeciesNetwork;
import com.ninni.species.server.packet.CruncherPelletSyncPacket;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.network.PacketDistributor;

public class CruncherPelletManager
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_INSTANCE = new GsonBuilder().create();
    public static final Map<ItemStack, CruncherPelletData> DATA = Maps.newHashMap();

    public CruncherPelletManager() {
        super(GSON_INSTANCE, "gameplay/cruncher_pellets");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        DATA.clear();
        object.forEach((resourceLocation, jsonElement) -> {
            CruncherPelletData data = CruncherPelletData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).result().orElseGet(() -> {
                Species.LOGGER.error("Failed to read Cruncher pellet recipe for resource {}", resourceLocation);
                return null;
            });
            if (data != null && data.item.m_41720_() != Items.f_41852_) {
                DATA.put(data.item, data);
            }
        });
        Species.LOGGER.info("Loaded {} Cruncher pellet recipes", (Object)DATA.size());
    }

    public void onDatapackSync(@Nullable ServerPlayer player) {
        if (DATA.isEmpty()) {
            return;
        }
        HashBiMap registryMap = HashBiMap.create();
        for (CruncherPelletData data : DATA.values()) {
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)data.item().m_41720_());
            if (id == null) continue;
            registryMap.put((Object)id, (Object)data);
        }
        if (player == null) {
            SpeciesNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new CruncherPelletSyncPacket((BiMap<ResourceLocation, CruncherPelletData>)registryMap));
        } else {
            SpeciesNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CruncherPelletSyncPacket((BiMap<ResourceLocation, CruncherPelletData>)registryMap));
        }
    }

    public void synchronizeRegistryForClient(Map<ResourceLocation, CruncherPelletData> newData) {
        DATA.clear();
        for (CruncherPelletData data : newData.values()) {
            if (data.item().m_41720_() == Items.f_41852_) continue;
            DATA.put(data.item(), data);
        }
    }

    public record CruncherPelletData(EntityType<?> entityType, ItemStack item, int minTries, int maxTries) {
        public static final Codec<CruncherPelletData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256780_.m_194605_().fieldOf("type").forGetter(CruncherPelletData::entityType), (App)ItemStack.f_41582_.fieldOf("item").forGetter(CruncherPelletData::item), (App)Codec.INT.fieldOf("minTries").forGetter(CruncherPelletData::minTries), (App)Codec.INT.fieldOf("maxTries").forGetter(CruncherPelletData::maxTries)).apply((Applicative)instance, CruncherPelletData::new));

        public static CruncherPelletData fromNetwork(FriendlyByteBuf buf) {
            EntityType type = (EntityType)buf.m_236816_((IdMap)BuiltInRegistries.f_256780_);
            ItemStack item = buf.m_130267_();
            int minTries = buf.m_130242_();
            int maxTries = buf.m_130242_();
            return new CruncherPelletData(type, item, minTries, maxTries);
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_236818_((IdMap)BuiltInRegistries.f_256780_, this.entityType);
            buf.m_130055_(this.item);
            buf.m_130130_(this.minTries);
            buf.m_130130_(this.maxTries);
        }
    }
}

