/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ninni.species.registry.SpeciesBlockEntities;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.server.block.MobHeadBlock;
import com.ninni.species.server.block.entity.MobHeadBlockEntity;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallMobHeadBlock
extends BaseEntityBlock
implements Equipable {
    private final MobHeadBlock.Type type;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> GHOUL_AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)2.0, (double)4.0, (double)8.0, (double)14.0, (double)11.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)2.0, (double)4.0, (double)0.0, (double)14.0, (double)11.0, (double)8.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)2.0, (double)8.0, (double)11.0, (double)14.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)8.0, (double)4.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0)));
    private static final Map<Direction, VoxelShape> WICKED_AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)10.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)10.0, (double)8.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)10.0, (double)12.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)10.0, (double)12.0)));
    private static final Map<Direction, VoxelShape> QUAKE_AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)1.5, (double)4.0, (double)6.0, (double)14.5, (double)11.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)1.5, (double)4.0, (double)0.0, (double)14.5, (double)11.0, (double)10.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)1.5, (double)10.0, (double)11.0, (double)14.5), (Object)Direction.WEST, (Object)Block.m_49796_((double)6.0, (double)4.0, (double)1.5, (double)16.0, (double)11.0, (double)14.5)));
    private static final Map<Direction, VoxelShape> BEWEREAGER_AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)3.0, (double)3.0, (double)6.0, (double)13.0, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)10.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)10.0, (double)13.0, (double)13.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)6.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0)));

    public WallMobHeadBlock(MobHeadBlock.Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState p_56331_, BlockGetter p_56332_, BlockPos p_56333_, CollisionContext p_56334_) {
        if (this.getType() == MobHeadBlock.Types.WICKED) {
            return WICKED_AABBS.get(p_56331_.m_61143_((Property)FACING));
        }
        if (this.getType() == MobHeadBlock.Types.GHOUL) {
            return GHOUL_AABBS.get(p_56331_.m_61143_((Property)FACING));
        }
        if (this.getType() == MobHeadBlock.Types.BEWEREAGER) {
            return BEWEREAGER_AABBS.get(p_56331_.m_61143_((Property)FACING));
        }
        return QUAKE_AABBS.get(p_56331_.m_61143_((Property)FACING));
    }

    public VoxelShape m_7952_(BlockState p_56336_, BlockGetter p_56337_, BlockPos p_56338_) {
        return Shapes.m_83040_();
    }

    public BlockState m_5573_(BlockPlaceContext p_58104_) {
        Direction[] adirection;
        BlockState blockstate = this.m_49966_();
        Level blockgetter = p_58104_.m_43725_();
        BlockPos blockpos = p_58104_.m_8083_();
        for (Direction direction : adirection = p_58104_.m_6232_()) {
            if (!direction.m_122434_().m_122479_()) continue;
            Direction direction1 = direction.m_122424_();
            blockstate = (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)direction1);
            if (blockgetter.m_8055_(blockpos.m_121945_(direction)).m_60629_(p_58104_)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState m_6843_(BlockState p_58109_, Rotation p_58110_) {
        return (BlockState)p_58109_.m_61124_((Property)FACING, (Comparable)p_58110_.m_55954_((Direction)p_58109_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_58106_, Mirror p_58107_) {
        return p_58106_.m_60717_(p_58107_.m_54846_((Direction)p_58106_.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_58112_) {
        p_58112_.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_151992_, BlockState p_151993_, BlockEntityType<T> p_151994_) {
        if (p_151992_.f_46443_) {
            boolean flag;
            boolean bl = flag = p_151993_.m_60713_((Block)SpeciesBlocks.GHOUL_HEAD.get()) || p_151993_.m_60713_((Block)SpeciesBlocks.GHOUL_WALL_HEAD.get()) || p_151993_.m_60713_((Block)SpeciesBlocks.BEWEREAGER_HEAD.get()) || p_151993_.m_60713_((Block)SpeciesBlocks.BEWEREAGER_WALL_HEAD.get());
            if (flag) {
                return WallMobHeadBlock.m_152132_(p_151994_, (BlockEntityType)((BlockEntityType)SpeciesBlockEntities.MOB_HEAD.get()), MobHeadBlockEntity::animation);
            }
        }
        return null;
    }

    public MobHeadBlock.Type getType() {
        return this.type;
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType computationType) {
        return false;
    }

    public EquipmentSlot m_40402_() {
        return EquipmentSlot.HEAD;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MobHeadBlockEntity(pos, state);
    }
}

