/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block;

import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.entity.mob.update_2.Springling;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpringlingEggBlock
extends Block {
    public static final int MAX_HATCH_LEVEL = 2;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    private static final int REGULAR_HATCH_TIME_TICKS = 24000;
    private static final int BOOSTED_HATCH_TIME_TICKS = 12000;
    private static final int RANDOM_HATCH_OFFSET_TICKS = 300;
    private static final VoxelShape SHAPE_LOWER = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_UPPER = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);

    public SpringlingEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.m_61143_(HALF);
        if (!(direction.m_122434_() != Direction.Axis.Y || doubleBlockHalf == DoubleBlockHalf.LOWER != (direction == Direction.UP) || blockState2.m_60713_((Block)this) && blockState2.m_61143_(HALF) != doubleBlockHalf)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !blockState.m_60710_((LevelReader)levelAccessor, blockPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public int getHatchLevel(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)HATCH);
    }

    private boolean isReadyToHatch(BlockState blockState) {
        return this.getHatchLevel(blockState) == 2;
    }

    public void m_213897_(BlockState state, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            if (!this.isReadyToHatch(state)) {
                serverLevel.m_5594_(null, blockPos, (SoundEvent)SpeciesSoundEvents.SPRINGLING_EGG_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + randomSource.m_188501_() * 0.2f);
                serverLevel.m_7731_(blockPos.m_7494_(), (BlockState)((BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(this.getHatchLevel(serverLevel.m_8055_(blockPos.m_7494_())) + 1)), 2);
                serverLevel.m_7731_(blockPos, (BlockState)state.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(this.getHatchLevel(state) + 1)), 2);
                return;
            }
            serverLevel.m_5594_(null, blockPos, (SoundEvent)SpeciesSoundEvents.SPRINGLING_EGG_HATCH.get(), SoundSource.BLOCKS, 0.7f, 0.9f + randomSource.m_188501_() * 0.2f);
            serverLevel.m_46961_(blockPos, false);
            Springling springling = (Springling)((EntityType)SpeciesEntities.SPRINGLING.get()).m_20615_((Level)serverLevel);
            if (springling != null) {
                Vec3 vec3 = blockPos.m_252807_();
                springling.m_6863_(true);
                springling.setMaxExtendedAmount(springling.m_217043_().m_188503_(10000) == 0 ? 24 : springling.m_217043_().m_216339_(7, 12));
                springling.m_7678_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), Mth.m_14177_((float)(serverLevel.f_46441_.m_188501_() * 360.0f)), 0.0f);
                serverLevel.m_7967_((Entity)springling);
            }
        }
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        boolean bl2 = SpringlingEggBlock.hatchBoost(blockPos);
        if (!level.m_5776_() && bl2) {
            level.m_46796_(3009, blockPos, 0);
        }
        int i = bl2 ? 12000 : 24000;
        int j = i / 3;
        level.m_220407_(GameEvent.f_157797_, blockPos, GameEvent.Context.m_223722_((BlockState)blockState));
        level.m_186460_(blockPos, (Block)this, j + level.f_46441_.m_188503_(300));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER : SHAPE_UPPER;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        if (blockPos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockPos.m_7494_()).m_60629_(blockPlaceContext)) {
            return super.m_5573_(blockPlaceContext);
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        BlockPos blockPos2 = blockPos.m_7494_();
        level.m_7731_(blockPos2, SpringlingEggBlock.copyWaterloggedFrom((LevelReader)level, blockPos2, (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)), 3);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        if (blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockState blockState2 = levelReader.m_8055_(blockPos.m_7495_());
            return blockState2.m_60713_((Block)this) && blockState2.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        }
        return super.m_7898_(blockState, levelReader, blockPos);
    }

    public static BlockState copyWaterloggedFrom(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(levelReader.m_46801_(blockPos)));
        }
        return blockState;
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                SpringlingEggBlock.preventCreativeDropFromBottomPart(level, blockPos, blockState, player);
            } else {
                SpringlingEggBlock.m_49881_((BlockState)blockState, (Level)level, (BlockPos)blockPos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.m_6240_(level, player, blockPos, Blocks.f_50016_.m_49966_(), blockEntity, itemStack);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockPos blockPos2;
        BlockState blockState2;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.m_61143_(HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (blockState2 = level.m_8055_(blockPos2 = blockPos.m_7495_())).m_60713_(blockState.m_60734_()) && blockState2.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState3 = blockState2.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(blockPos2, blockState3, 35);
            level.m_5898_(player, 2001, blockPos2, Block.m_49956_((BlockState)blockState2));
        }
    }

    public static boolean hatchBoost(BlockPos blockPos) {
        return blockPos.m_123342_() > 100;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HATCH, HALF});
    }
}

