/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block;

import com.ninni.species.registry.SpeciesBlockEntities;
import com.ninni.species.server.block.entity.CruncherEggBlockEntity;
import com.ninni.species.server.block.property.SpeciesProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CruncherEggBlock
extends BaseEntityBlock {
    public static final BooleanProperty CRACKED = SpeciesProperties.CRUNCHER_EGG_CRACKED;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private static final VoxelShape UPPER_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape CRACKED_UPPER_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public CruncherEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)CRACKED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.m_61143_(HALF);
        if (!(direction.m_122434_() != Direction.Axis.Y || doubleBlockHalf == DoubleBlockHalf.LOWER != (direction == Direction.UP) || blockState2.m_60713_((Block)this) && blockState2.m_61143_(HALF) != doubleBlockHalf)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !blockState.m_60710_((LevelReader)levelAccessor, blockPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        boolean lower = blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        boolean cracked = (Boolean)blockState.m_61143_((Property)CRACKED);
        VoxelShape upperShape = cracked ? CRACKED_UPPER_SHAPE : UPPER_SHAPE;
        VoxelShape bottomShape = Shapes.m_83144_();
        return lower ? bottomShape : upperShape;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        if (blockPos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockPos.m_7494_()).m_60629_(blockPlaceContext)) {
            return super.m_5573_(blockPlaceContext);
        }
        return null;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        BlockPos blockPos2 = blockPos.m_7494_();
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof CruncherEggBlockEntity) {
            CruncherEggBlockEntity cruncherEggBlockEntity = (CruncherEggBlockEntity)blockEntity;
            cruncherEggBlockEntity.setTarget(livingEntity);
        }
        level.m_7731_(blockPos2, CruncherEggBlock.copyWaterloggedFrom((LevelReader)level, blockPos2, (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)), 3);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        if (blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockState blockState2 = levelReader.m_8055_(blockPos.m_7495_());
            return blockState2.m_60713_((Block)this) && blockState2.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        }
        return super.m_7898_(blockState, levelReader, blockPos);
    }

    public static BlockState copyWaterloggedFrom(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(levelReader.m_46801_(blockPos)));
        }
        return blockState;
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                CruncherEggBlock.preventCreativeDropFromBottomPart(level, blockPos, blockState, player);
            } else {
                CruncherEggBlock.m_49881_((BlockState)blockState, (Level)level, (BlockPos)blockPos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.m_6240_(level, player, blockPos, Blocks.f_50016_.m_49966_(), blockEntity, itemStack);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockPos blockPos2;
        BlockState blockState2;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.m_61143_(HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (blockState2 = level.m_8055_(blockPos2 = blockPos.m_7495_())).m_60713_(blockState.m_60734_()) && blockState2.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState3 = blockState2.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(blockPos2, blockState3, 35);
            level.m_5898_(player, 2001, blockPos2, Block.m_49956_((BlockState)blockState2));
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return CruncherEggBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)SpeciesBlockEntities.CRUNCHER_EGG.get()), (BlockEntityTicker)(level.f_46443_ ? CruncherEggBlockEntity::clientTick : CruncherEggBlockEntity::serverTick));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, CRACKED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CruncherEggBlockEntity(blockPos, blockState);
    }
}

