/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.compat.jei;

import com.ninni.species.compat.jei.JEIPlugin;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.server.data.CruncherPelletManager;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CruncherPelletCategory
implements IRecipeCategory<CruncherPelletManager.CruncherPelletData> {
    public static final ResourceLocation UID = new ResourceLocation("species", "cruncher_pellet");
    public static final ResourceLocation TEXTURE = new ResourceLocation("species", "textures/gui/jei/cruncher_pellet.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotDrawable;
    private final IDrawable cruncher;
    private final IDrawable sparkles;
    private final IDrawable resultArrow;

    public CruncherPelletCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(150, 40);
        this.cruncher = guiHelper.createDrawable(TEXTURE, 0, 16, 68, 44);
        this.icon = guiHelper.createDrawable(TEXTURE, 0, 0, 16, 16);
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.sparkles = guiHelper.createDrawable(TEXTURE, 0, 28, 18, 13);
        this.resultArrow = guiHelper.createDrawable(TEXTURE, 0, 16, 21, 12);
    }

    public RecipeType<CruncherPelletManager.CruncherPelletData> getRecipeType() {
        return JEIPlugin.CRUNCHER_PELLET;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.species.cruncher_pellet");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CruncherPelletManager.CruncherPelletData recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 43, 12).addItemStack(recipe.item());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 12).addItemStack(((Item)SpeciesItems.CRUNCHER_PELLET.get()).m_7968_())).addTooltipCallback((view, tooltip) -> {
            String entityName = recipe.entityType().m_20676_().getString();
            tooltip.add(Component.m_237110_((String)"jei.species.cruncher_pellet.mob", (Object[])new Object[]{entityName}).m_6270_(Style.f_131099_.m_178520_(49913)));
            tooltip.add(Component.m_237110_((String)"jei.species.cruncher_pellet.amount", (Object[])new Object[]{recipe.minTries(), recipe.maxTries()}).m_6270_(Style.f_131099_.m_178520_(32222)));
        });
    }

    public void draw(CruncherPelletManager.CruncherPelletData recipe, IRecipeSlotsView view, GuiGraphics stack, double mouseX, double mouseY) {
        this.cruncher.draw(stack, 23, -1);
        this.slotDrawable.draw(stack, 90, 11);
    }
}

