/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.species.server.entity.mob.update_3.Harpoon;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HarpoonRenderer<T extends Harpoon>
extends EntityRenderer<T> {
    public static final ResourceLocation TEXTURE_ROPE = new ResourceLocation("species", "textures/entity/hanger/coil/coil_rope.png");
    public static final ResourceLocation TEXTURE_HOOK = new ResourceLocation("species", "textures/entity/hanger/hook/harpoon_hook.png");

    public HarpoonRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(T entity, float v, float v1, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Entity entity2;
        super.m_7392_(entity, v, v1, poseStack, buffer, packedLight);
        if (entity.m_19749_() != null && (entity2 = entity.m_19749_()) instanceof Player) {
            Player player = (Player)entity2;
            if (!((Harpoon)((Object)entity)).ownerPositionO.equals((Object)new Vec3(0.0, 0.0, 0.0)) && !((Harpoon)((Object)entity)).ownerPosition.equals((Object)new Vec3(0.0, 0.0, 0.0))) {
                Vec3 playerPositionLerped = new Vec3(Mth.m_14139_((double)v1, (double)((Harpoon)((Object)entity)).ownerPositionO.f_82479_, (double)((Harpoon)((Object)entity)).ownerPosition.f_82479_), Mth.m_14139_((double)v1, (double)((Harpoon)((Object)entity)).ownerPositionO.f_82480_, (double)((Harpoon)((Object)entity)).ownerPosition.f_82480_), Mth.m_14139_((double)v1, (double)((Harpoon)((Object)entity)).ownerPositionO.f_82481_, (double)((Harpoon)((Object)entity)).ownerPosition.f_82481_));
                Vec3 harpoonPositionLerped = new Vec3(Mth.m_14139_((double)v1, (double)((Harpoon)((Object)entity)).f_19854_, (double)entity.m_20185_()), Mth.m_14139_((double)v1, (double)((Harpoon)((Object)entity)).f_19855_, (double)entity.m_20186_()), Mth.m_14139_((double)v1, (double)((Harpoon)((Object)entity)).f_19856_, (double)entity.m_20189_()));
                VertexConsumer builder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
                Vec3 base = new Vec3(0.0, -0.05, 0.0);
                float yawRad = -player.m_146908_() * ((float)Math.PI / 180);
                float pitchRad = player.m_146909_() * ((float)Math.PI / 180);
                Vec3 handOffset = new Vec3(player.m_7655_() == InteractionHand.MAIN_HAND && player.m_5737_() == HumanoidArm.RIGHT || player.m_7655_() == InteractionHand.OFF_HAND && player.m_5737_() == HumanoidArm.LEFT ? -0.25 : 0.25, 0.0, 0.0);
                Vec3 tip = playerPositionLerped.m_82546_(harpoonPositionLerped).m_82520_(0.0, (double)player.m_20206_(), 0.0).m_82549_(handOffset.m_82524_(yawRad).m_82496_(pitchRad));
                Vec3 direction = tip.m_82546_(base);
                double length = direction.m_82553_();
                if (!entity.m_6084_()) {
                    return;
                }
                Vec3 dirNorm = direction.m_82541_();
                Vec3 up = Math.abs(dirNorm.f_82480_) < 0.9 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
                Vec3 right = dirNorm.m_82537_(up).m_82541_().m_82490_(0.2);
                Vec3 forward = dirNorm.m_82537_(right).m_82541_().m_82490_(0.2);
                int startLight = ((Harpoon)((Object)entity)).getAnchorPos() == null ? packedLight : LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)((Harpoon)((Object)entity)).getAnchorPos().m_7495_());
                int endLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)BlockPos.m_274446_((Position)player.m_20182_()));
                int avgPackedLight = HarpoonRenderer.averagePackedLight(startLight, endLight);
                poseStack.m_85836_();
                float vMax = (float)length;
                this.drawRopeQuad(poseStack, builder, base, tip, right, vMax, avgPackedLight, 1.0f, 1.0f);
                this.drawRopeQuad(poseStack, builder, base, tip, forward, vMax, avgPackedLight, 1.0f, 1.0f);
                poseStack.m_85849_();
                VertexConsumer hookBuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE_HOOK));
                poseStack.m_85836_();
                poseStack.m_85837_(base.f_82479_, base.f_82480_ + 0.15, base.f_82481_);
                float hookScale = 0.5f;
                poseStack.m_85841_(-hookScale, hookScale, hookScale);
                int hookLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)BlockPos.m_274446_((Position)entity.m_20182_()));
                this.drawHookCross(poseStack, hookBuilder, hookLight);
                poseStack.m_85849_();
            }
        }
    }

    private static int averagePackedLight(int a, int b) {
        int blockA = a & 0xFFFF;
        int skyA = a >> 20 & 0xFFFF;
        int blockB = b & 0xFFFF;
        int skyB = b >> 20 & 0xFFFF;
        int block = (blockA + blockB) / 2;
        int sky = (skyA + skyB) / 2;
        return sky << 20 | block;
    }

    public boolean shouldRender(T hook, Frustum frustum, double v, double v1, double v2) {
        if (hook.m_19749_() != null) {
            return true;
        }
        return super.m_5523_(hook, frustum, v, v1, v2);
    }

    public ResourceLocation getTextureLocation(T p_114482_) {
        return TEXTURE_ROPE;
    }

    private void drawHookCross(PoseStack poseStack, VertexConsumer builder, int packedLight) {
        PoseStack.Pose pose = poseStack.m_85850_();
        float halfSize = 0.5f;
        Vec3 viewNormal = new Vec3((double)pose.m_252922_().m02(), (double)pose.m_252922_().m12(), (double)pose.m_252922_().m22()).m_82541_();
        builder.m_252986_(pose.m_252922_(), -halfSize, -halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)viewNormal.f_82479_, (float)viewNormal.f_82480_, (float)viewNormal.f_82481_).m_5752_();
        builder.m_252986_(pose.m_252922_(), halfSize, -halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)viewNormal.f_82479_, (float)viewNormal.f_82480_, (float)viewNormal.f_82481_).m_5752_();
        builder.m_252986_(pose.m_252922_(), halfSize, halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)viewNormal.f_82479_, (float)viewNormal.f_82480_, (float)viewNormal.f_82481_).m_5752_();
        builder.m_252986_(pose.m_252922_(), -halfSize, halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)viewNormal.f_82479_, (float)viewNormal.f_82480_, (float)viewNormal.f_82481_).m_5752_();
        Vec3 viewNormal2 = new Vec3((double)pose.m_252922_().m00(), (double)pose.m_252922_().m10(), (double)pose.m_252922_().m20()).m_82541_();
        builder.m_252986_(pose.m_252922_(), 0.0f, -halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)viewNormal2.f_82479_, (float)viewNormal2.f_82480_, (float)viewNormal2.f_82481_).m_5752_();
        builder.m_252986_(pose.m_252922_(), 0.0f, -halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)viewNormal2.f_82479_, (float)viewNormal2.f_82480_, (float)viewNormal2.f_82481_).m_5752_();
        builder.m_252986_(pose.m_252922_(), 0.0f, halfSize, halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)viewNormal2.f_82479_, (float)viewNormal2.f_82480_, (float)viewNormal2.f_82481_).m_5752_();
        builder.m_252986_(pose.m_252922_(), 0.0f, halfSize, -halfSize).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_((float)viewNormal2.f_82479_, (float)viewNormal2.f_82480_, (float)viewNormal2.f_82481_).m_5752_();
    }

    void drawRopeQuad(PoseStack poseStack, VertexConsumer builder, Vec3 base, Vec3 tip, Vec3 side, float vMax, int packedLight, float baseOpacity, float tipOpacity) {
        PoseStack.Pose pose = poseStack.m_85850_();
        builder.m_252986_(pose.m_252922_(), (float)(base.f_82479_ + side.f_82479_), (float)(base.f_82480_ + side.f_82480_), (float)(base.f_82481_ + side.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, baseOpacity).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), (float)(base.f_82479_ - side.f_82479_), (float)(base.f_82480_ - side.f_82480_), (float)(base.f_82481_ - side.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, baseOpacity).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), (float)(tip.f_82479_ - side.f_82479_), (float)(tip.f_82480_ - side.f_82480_), (float)(tip.f_82481_ - side.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, tipOpacity).m_7421_(1.0f, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), (float)(tip.f_82479_ + side.f_82479_), (float)(tip.f_82480_ + side.f_82480_), (float)(tip.f_82481_ + side.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, tipOpacity).m_7421_(0.0f, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

