/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.CraftingContainerRecipeTransferHandlerServer;

public record JeiTransferRecipeMessage(ResourceLocation recipeId, ResourceLocation recipeTypeId, Map<Integer, Integer> matchingItems, List<Integer> craftingSlotIndexes, List<Integer> inventorySlotIndexes, boolean maxTransfer) {
    public static void encode(JeiTransferRecipeMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130085_(msg.recipeId);
        packetBuffer.m_130085_(msg.recipeTypeId);
        packetBuffer.m_236831_(msg.matchingItems, FriendlyByteBuf::writeInt, FriendlyByteBuf::writeInt);
        packetBuffer.m_236828_(msg.craftingSlotIndexes, FriendlyByteBuf::writeInt);
        packetBuffer.m_236828_(msg.inventorySlotIndexes, FriendlyByteBuf::writeInt);
        packetBuffer.writeBoolean(msg.maxTransfer);
    }

    public static JeiTransferRecipeMessage decode(FriendlyByteBuf packetBuffer) {
        return new JeiTransferRecipeMessage(packetBuffer.m_130281_(), packetBuffer.m_130281_(), packetBuffer.m_236841_(HashMap::new, FriendlyByteBuf::readInt, FriendlyByteBuf::readInt), packetBuffer.m_236845_(FriendlyByteBuf::readInt), packetBuffer.m_236845_(FriendlyByteBuf::readInt), packetBuffer.readBoolean());
    }

    static void onMessage(JeiTransferRecipeMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> JeiTransferRecipeMessage.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(JeiTransferRecipeMessage msg, @Nullable ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        RecipeType recipeType = (RecipeType)ForgeRegistries.RECIPE_TYPES.getValue(msg.recipeTypeId);
        if (recipeType == null) {
            return;
        }
        CraftingContainerRecipeTransferHandlerServer.setItemsWithSlotIDMap((Player)sender, msg.recipeId, recipeType, msg.matchingItems, msg.craftingSlotIndexes, msg.inventorySlotIndexes, msg.maxTransfer);
    }
}

