/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.societytrading.util;

import dev.latvian.mods.kubejs.stages.Stages;
import io.github.chakyl.societytrading.SocietyTrading;
import io.github.chakyl.societytrading.data.Shop;
import io.github.chakyl.societytrading.trading.ShopOffer;
import io.github.chakyl.societytrading.trading.ShopOffers;
import io.github.chakyl.societytrading.util.ShopComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import sereneseasons.api.season.SeasonHelper;

public class ShopData {
    public static Collection<Shop> getFilteredShops(Collection<Shop> shops, Player player) {
        ArrayList<Shop> newShops = new ArrayList<Shop>();
        for (Shop shop : shops) {
            boolean flag;
            boolean bl = flag = shop.hiddenFromSelector() == false;
            if (SocietyTrading.SERENE_SEASONS_INSTALLED && !shop.seasonsRequired().isEmpty() && !shop.seasonsRequired().contains(SeasonHelper.getSeasonState((Level)player.m_9236_()).getSubSeason().m_7912_())) {
                flag = false;
            }
            if (SocietyTrading.KUBEJS_INSTALLED) {
                if (!shop.stageRequired().isEmpty() && !Stages.get((Player)player).has(shop.stageRequired())) {
                    flag = false;
                }
                if (!shop.stageOverride().isEmpty() && Stages.get((Player)player).has(shop.stageRequired())) {
                    flag = true;
                }
            }
            if (!flag) continue;
            newShops.add(shop);
        }
        ShopComparator comparator = new ShopComparator();
        comparator.setSortingBy(ShopComparator.Order.ID);
        Collections.sort(newShops, comparator);
        return newShops;
    }

    public static Shop getShopFromEntity(Collection<Shop> shops, LivingEntity entity) {
        for (Shop shop : shops) {
            if (shop.entity() != entity.m_6095_()) continue;
            return shop;
        }
        return null;
    }

    public static Shop getShopFromBlockState(Collection<Shop> shops, BlockState blockState) {
        for (Shop shop : shops) {
            if (shop.blockTag() == null || !blockState.m_204336_(shop.blockTag())) continue;
            return shop;
        }
        return null;
    }

    public static Shop getShopFromVillagerProfession(Collection<Shop> shops, String profession) {
        for (Shop shop : shops) {
            if (!shop.villagerProfession().equals(profession)) continue;
            return shop;
        }
        return null;
    }

    public static ShopOffers getFilteredTrades(ShopOffers trades, Player player) {
        ShopOffers newTrades = new ShopOffers();
        for (ShopOffer trade : trades) {
            if (!trade.playerCanSee(player)) continue;
            newTrades.add(trade);
        }
        return newTrades;
    }

    public static String formatPrice(String number) {
        return ShopData.formatPrice(number, true);
    }

    public static String formatPrice(String number, boolean truncateMillionsBillions) {
        if (truncateMillionsBillions) {
            if (number.length() < 4) {
                return number;
            }
            if (number.length() > 9) {
                return number.charAt(0) + "." + number.charAt(1) + "B";
            }
            if (number.length() > 6) {
                StringBuilder out = new StringBuilder(3);
                for (int i = 0; i < number.length() - 6; ++i) {
                    out.append(number.charAt(i));
                }
                if (number.length() == 7) {
                    out.append('.');
                    out.append(number.charAt(1));
                }
                out.append("M");
                return out.toString();
            }
        }
        int start = number.length() % 3;
        StringBuilder out = new StringBuilder(number.length() + number.length() / 3);
        out.append(number, 0, start);
        for (int i = 0; i < number.length() / 3; ++i) {
            if (i != 0 || start != 0) {
                out.append(",");
            }
            out.append(number, i * 3 + start, i * 3 + start + 3);
        }
        return out.toString();
    }
}

